% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/NcDataReader.R
\name{NcDataReader}
\alias{NcDataReader}
\title{NetCDF file data reader for 'startR'}
\usage{
NcDataReader(file_path = NULL, file_object = NULL, file_selectors = NULL,
  inner_indices = NULL, synonims)
}
\arguments{
\item{file_path}{A character string indicating the path to the data file to 
read. See details in the documentation of the parameter 'file_data_reader' 
of the function Start(). The default value is NULL.}

\item{file_object}{An open connection to a NetCDF file, optionally with 
additional header information. See details in the documentation of the 
parameter 'file_data_reader' of the function Start(). The default value is 
NULL.}

\item{file_selectors}{A named list containing the information of the path of 
the file to read data from. It is automatically provided by Start(). See 
details in the documentation of the parameter 'file_data_reader' of the 
function Start(). The default value is NULL.}

\item{inner_indices}{A named list of numeric vectors indicating the indices 
to take from each of the inner dimensions in the requested file. It is 
automatically provided by Start(). See details in the documentation of the 
parameter 'file_data_reader' of the function Start(). The default value is 
NULL.}

\item{synonims}{A named list indicating the synonims for the dimension names 
to look for in the requested file, exactly as provided in the parameter 
'synonims' in a Start() call. See details in the documentation of the 
parameter 'file_data_reader' of the function Start().}
}
\value{
A multidimensional data array with the named dimensions and indices 
 requested in 'inner_indices', potentially with the attribute 'variables' 
 with additional auxiliary data. See details in the documentation of the 
 parameter 'file_data_reader' of the function Start().
}
\description{
This is a data reader function for NetCDF files, intended for use as parameter 
file_data_reader in a Start() call. This function complies with the 
input/output interface required by Start() defined in the documentation for 
the parameter 'file_data_reader'.\cr\cr
This function uses the function NcToArray() in the package 'easyNCDF', which 
in turn uses nc_var_get() in the package 'ncdf4'.
}
\examples{
 data_path <- system.file('extdata', package = 'startR', mustWork = TRUE)
 file_to_open <- file.path(data_path, 'obs/monthly_mean/tos/tos_200011.nc')
 file_selectors <- c(dat = 'dat1', var = 'tos', sdate = '200011')
 first_round_indices <- list(time = 1, latitude = 1:8, longitude = 1:16)
 synonims <- list(dat = 'dat', var = 'var', sdate = 'sdate', time = 'time',
                  latitude = 'latitude', longitude = 'longitude')
 sub_array <- NcDataReader(file_to_open, NULL, file_selectors,
                           first_round_indices, synonims)
}
\seealso{
\code{\link{NcOpener}} \code{\link{NcDimReader}} 
 \code{\link{NcCloser}} \code{\link{NcVarReader}}
}

