#' Mortality Reporting System
#'
#' Selection of data from the 122 Cities Mortality Reporting System, for the
#' first 11 weeks of 1962.
#'
#' The original dataset begins in 1962. For each week, in 122 US cities,
#' mortality figures by age group and cause, considered separately, are included
#' (i.e., the combination of age group and cause is not included). In the cause,
#' only a distinction is made between pneumonia or influenza and others.
#'
#' @format A `tibble`.
#' @source \url{https://catalog.data.gov/dataset/deaths-in-122-u-s-cities-1962-2016-122-cities-mortality-reporting-system}
"mrs"

#' Mortality Reporting System by Age
#'
#' Selection of data from the 122 Cities Mortality Reporting System by age
#' group, for the first 9 weeks of 1962.
#'
#' The original dataset begins in 1962. For each week, in 122 US cities,
#' mortality figures by age group and cause, considered separately, are included
#' (i.e., the combination of age group and cause is not included). In the cause,
#' only a distinction is made between pneumonia or influenza and others.
#'
#' Two additional dates have been generated, which were not present in the
#' original dataset.
#'
#' @format A `tibble`.
#' @source \url{https://catalog.data.gov/dataset/deaths-in-122-u-s-cities-1962-2016-122-cities-mortality-reporting-system}
"mrs_age"

#' Mortality Reporting System by Age Test
#'
#' Selection of data from the 2 Cities Mortality Reporting System by age
#' group, for the first 3 weeks of 1962.
#'
#' The original dataset begins in 1962. For each week, in 122 US cities,
#' mortality figures by age group and cause, considered separately, are included
#' (i.e., the combination of age group and cause is not included). In the cause,
#' only a distinction is made between pneumonia or influenza and others.
#'
#' Two additional dates have been generated, which were not present in the
#' original dataset.
#'
#' @format A `tibble`.
#' @source \url{https://catalog.data.gov/dataset/deaths-in-122-u-s-cities-1962-2016-122-cities-mortality-reporting-system}
"mrs_age_test"

#' Mortality Reporting System by Age for Week Test
#'
#' Selection of data from the 3 Cities Mortality Reporting System by age
#' group, for week 4 of 1962. It also includes some isolated data from previous
#' weeks that is supposed to be corrections for data errors.
#'
#' The original dataset begins in 1962. For each week, in 122 US cities,
#' mortality figures by age group and cause, considered separately, are included
#' (i.e., the combination of age group and cause is not included). In the cause,
#' only a distinction is made between pneumonia or influenza and others.
#'
#' Two additional dates have been generated, which were not present in the
#' original dataset.
#'
#' @format A `tibble`.
#' @source \url{https://catalog.data.gov/dataset/deaths-in-122-u-s-cities-1962-2016-122-cities-mortality-reporting-system}
"mrs_age_w_test"

#' Mortality Reporting System by Age for Week 10
#'
#' Selection of data from the 122 Cities Mortality Reporting System by age
#' group, for week 10 of 1962. It also includes some isolated data from previous
#' weeks that is supposed to be corrections for data errors.
#'
#' The original dataset begins in 1962. For each week, in 122 US cities,
#' mortality figures by age group and cause, considered separately, are included
#' (i.e., the combination of age group and cause is not included). In the cause,
#' only a distinction is made between pneumonia or influenza and others.
#'
#' Two additional dates have been generated, which were not present in the
#' original dataset.
#'
#' @format A `tibble`.
#' @source \url{https://catalog.data.gov/dataset/deaths-in-122-u-s-cities-1962-2016-122-cities-mortality-reporting-system}
"mrs_age_w10"

#' Mortality Reporting System by Age for Week 11
#'
#' Selection of data from the 122 Cities Mortality Reporting System by age
#' group, for week 11 of 1962. It also includes some isolated data from previous
#' weeks that is supposed to be corrections for data errors.
#'
#' The original dataset begins in 1962. For each week, in 122 US cities,
#' mortality figures by age group and cause, considered separately, are included
#' (i.e., the combination of age group and cause is not included). In the cause,
#' only a distinction is made between pneumonia or influenza and others.
#'
#' Two additional dates have been generated, which were not present in the
#' original dataset.
#'
#' @format A `tibble`.
#' @source \url{https://catalog.data.gov/dataset/deaths-in-122-u-s-cities-1962-2016-122-cities-mortality-reporting-system}
"mrs_age_w11"


#' Mortality Reporting System by Cause
#'
#' Selection of data from the 122 Cities Mortality Reporting System by cause,
#' for the first 9 weeks of 1962.
#'
#' The original dataset begins in 1962. For each week, in 122 US cities,
#' mortality figures by age group and cause, considered separately, are included
#' (i.e., the combination of age group and cause is not included). In the cause,
#' only a distinction is made between pneumonia or influenza and others.
#'
#' Two additional dates have been generated, which were not present in the
#' original dataset.
#'
#' @format A `tibble`.
#' @source \url{https://catalog.data.gov/dataset/deaths-in-122-u-s-cities-1962-2016-122-cities-mortality-reporting-system}
"mrs_cause"

#' Mortality Reporting System by Cause Test
#'
#' Selection of data from the 2 Cities Mortality Reporting System by cause,
#' for the first 3 weeks of 1962.
#'
#' The original dataset begins in 1962. For each week, in 122 US cities,
#' mortality figures by age group and cause, considered separately, are included
#' (i.e., the combination of age group and cause is not included). In the cause,
#' only a distinction is made between pneumonia or influenza and others.
#'
#' Two additional dates have been generated, which were not present in the
#' original dataset.
#'
#' @format A `tibble`.
#' @source \url{https://catalog.data.gov/dataset/deaths-in-122-u-s-cities-1962-2016-122-cities-mortality-reporting-system}
"mrs_cause_test"

#' Mortality Reporting System by Cause for Week Test
#'
#' Selection of data from the 3 Cities Mortality Reporting System by cause,
#' for week 4 of 1962. It also includes some isolated data from previous weeks
#' that is supposed to be additional data not considered before.
#'
#' The original dataset begins in 1962. For each week, in 122 US cities,
#' mortality figures by age group and cause, considered separately, are included
#' (i.e., the combination of age group and cause is not included). In the cause,
#' only a distinction is made between pneumonia or influenza and others.
#'
#' Two additional dates have been generated, which were not present in the
#' original dataset.
#'
#' @format A `tibble`.
#' @source \url{https://catalog.data.gov/dataset/deaths-in-122-u-s-cities-1962-2016-122-cities-mortality-reporting-system}
"mrs_cause_w_test"

#' Mortality Reporting System by Cause for Week 10
#'
#' Selection of data from the 122 Cities Mortality Reporting System by cause,
#' for week 10 of 1962. It also includes some isolated data from previous weeks
#' that is supposed to be additional data not considered before.
#'
#' The original dataset begins in 1962. For each week, in 122 US cities,
#' mortality figures by age group and cause, considered separately, are included
#' (i.e., the combination of age group and cause is not included). In the cause,
#' only a distinction is made between pneumonia or influenza and others.
#'
#' Two additional dates have been generated, which were not present in the
#' original dataset.
#'
#' @format A `tibble`.
#' @source \url{https://catalog.data.gov/dataset/deaths-in-122-u-s-cities-1962-2016-122-cities-mortality-reporting-system}
"mrs_cause_w10"

#' Mortality Reporting System by Cause for Week 11
#'
#' Selection of data from the 122 Cities Mortality Reporting System by cause,
#' for week 11 of 1962. It also includes some isolated data from previous weeks
#' that is supposed to be additional data not considered before.
#'
#' The original dataset begins in 1962. For each week, in 122 US cities,
#' mortality figures by age group and cause, considered separately, are included
#' (i.e., the combination of age group and cause is not included). In the cause,
#' only a distinction is made between pneumonia or influenza and others.
#'
#' Two additional dates have been generated, which were not present in the
#' original dataset.
#'
#' @format A `tibble`.
#' @source \url{https://catalog.data.gov/dataset/deaths-in-122-u-s-cities-1962-2016-122-cities-mortality-reporting-system}
"mrs_cause_w11"

#' Star Definition for Mortality Reporting System by Age
#'
#' Definition of facts and dimensions for the Mortality Reporting System
#' considering the age classification.
#'
#' @examples
#' # Defined by:
#'
#' library(tidyr)
#'
#' dm_mrs_age <- dimensional_model() %>%
#'   define_fact(
#'     name = "mrs_age",
#'     measures = c(
#'       "Deaths"
#'     ),
#'     agg_functions = c(
#'       "SUM"
#'     ),
#'     nrow_agg = "nrow_agg"
#'   ) %>%
#'   define_dimension(
#'     name = "when",
#'     attributes = c(
#'       "Week Ending Date",
#'       "WEEK",
#'       "Year"
#'     )
#'   ) %>%
#'   define_dimension(
#'     name = "when_available",
#'     attributes = c(
#'       "Data Availability Date",
#'       "Data Availability Week",
#'       "Data Availability Year"
#'     )
#'   ) %>%
#'   define_dimension(
#'     name = "where",
#'     attributes = c(
#'       "REGION",
#'       "State",
#'       "City"
#'     )
#'   ) %>%
#'   define_dimension(
#'     name = "who",
#'     attributes = c(
#'       "Age Range"
#'     )
#'   )
#'
#' @format A `dimensional_model` object.
"dm_mrs_age"

#' Star Definition for Mortality Reporting System by Cause
#'
#' Definition of facts and dimensions for the Mortality Reporting System
#' considering the cause classification.
#'
#' @examples
#' # Defined by:
#'
#' library(tidyr)
#'
#' dm_mrs_cause <- dimensional_model() %>%
#'   define_fact(
#'     name = "mrs_cause",
#'     measures = c(
#'       "Pneumonia and Influenza Deaths",
#'       "Other Deaths"
#'     ),
#'   ) %>%
#'   define_dimension(
#'     name = "when",
#'     attributes = c(
#'       "Week Ending Date",
#'       "WEEK",
#'       "Year"
#'     )
#'   ) %>%
#'   define_dimension(
#'     name = "when_received",
#'     attributes = c(
#'       "Reception Date",
#'       "Reception Week",
#'       "Reception Year"
#'     )
#'   ) %>%
#'   define_dimension(
#'     name = "when_available",
#'     attributes = c(
#'       "Data Availability Date",
#'       "Data Availability Week",
#'       "Data Availability Year"
#'     )
#'   ) %>%
#'   define_dimension(
#'     name = "where",
#'     attributes = c(
#'       "REGION",
#'       "State",
#'       "City"
#'     )
#'   )
#'
#' @format A `dimensional_model` object.
"dm_mrs_cause"

#' Star Schema for Mortality Reporting System by Age
#'
#' Star Schema for the Mortality Reporting System considering the age
#' classification.
#'
#' @examples
#' # Defined by:
#'
#' library(tidyr)
#'
#' st_mrs_age <- star_schema(mrs_age, dm_mrs_age) %>%
#'   role_playing_dimension(
#'     dim_names = c("when", "when_available"),
#'     name = "When Common",
#'     attributes = c("date", "week", "year")
#'   ) %>%
#'   snake_case() %>%
#'   character_dimensions(NA_replacement_value = "Unknown",
#'                        length_integers = list(week = 2))
#'
#' @format A `star_schema` object.
"st_mrs_age"

#' Star Schema for Mortality Reporting System by Age Test
#'
#' Star Schema for the Mortality Reporting System considering the age
#' classification data test.
#'
#' @examples
#' # Defined by:
#'
#' library(tidyr)
#'
#' st_mrs_age_test <- star_schema(mrs_age_test, dm_mrs_age) %>%
#'   role_playing_dimension(
#'     dim_names = c("when", "when_available"),
#'     name = "When Common",
#'     attributes = c("date", "week", "year")
#'   ) %>%
#'   snake_case() %>%
#'   character_dimensions(NA_replacement_value = "Unknown",
#'                        length_integers = list(week = 2))
#'
#' @format A `star_schema` object.
"st_mrs_age_test"

#' Star Schema for Mortality Reporting System by Age for Week Test
#'
#' Star Schema for the Mortality Reporting System considering the age
#' classification data test, for week 4 of 1962. It also includes some isolated
#' data from previous weeks that is supposed to be corrections for data errors.
#'
#' @examples
#' # Defined by:
#'
#' library(tidyr)
#'
#' st_mrs_age_w_test <- star_schema(mrs_age_w_test, dm_mrs_age) %>%
#'   role_playing_dimension(
#'     dim_names = c("when", "when_available"),
#'     name = "When Common",
#'     attributes = c("date", "week", "year")
#'   ) %>%
#'   snake_case() %>%
#'   character_dimensions(NA_replacement_value = "Unknown",
#'                        length_integers = list(week = 2))
#'
#' @format A `star_schema` object.
"st_mrs_age_w_test"

#' Star Schema for Mortality Reporting System by Age for Week 10
#'
#' Star Schema for the Mortality Reporting System considering the age
#' classification data, for week 10 of 1962. It also includes some isolated data
#' from previous weeks that is supposed to be corrections for data errors.
#'
#' @examples
#' # Defined by:
#'
#' library(tidyr)
#'
#' st_mrs_age_w10 <- star_schema(mrs_age_w10, dm_mrs_age) %>%
#'   role_playing_dimension(
#'     dim_names = c("when", "when_available"),
#'     name = "When Common",
#'     attributes = c("date", "week", "year")
#'   ) %>%
#'   snake_case() %>%
#'   character_dimensions(NA_replacement_value = "Unknown",
#'                        length_integers = list(week = 2))
#'
#' @format A `star_schema` object.
"st_mrs_age_w10"

#' Star Schema for Mortality Reporting System by Age for Week 11
#'
#' Star Schema for the Mortality Reporting System considering the age
#' classification data, for week 11 of 1962. It also includes some isolated data
#' from previous weeks that is supposed to be corrections for data errors.
#'
#' @examples
#' # Defined by:
#'
#' library(tidyr)
#'
#' st_mrs_age_w11 <- star_schema(mrs_age_w11, dm_mrs_age) %>%
#'   role_playing_dimension(
#'     dim_names = c("when", "when_available"),
#'     name = "When Common",
#'     attributes = c("date", "week", "year")
#'   ) %>%
#'   snake_case() %>%
#'   character_dimensions(NA_replacement_value = "Unknown",
#'                        length_integers = list(week = 2))
#'
#' @format A `star_schema` object.
"st_mrs_age_w11"

#' Star Schema for Mortality Reporting System by Cause
#'
#' Star Schema for the Mortality Reporting System considering the cause
#' classification.
#'
#' @examples
#' # Defined by:
#'
#' library(tidyr)
#'
#' st_mrs_cause <- star_schema(mrs_cause, dm_mrs_cause) %>%
#'   snake_case() %>%
#'   character_dimensions(
#'     NA_replacement_value = "Unknown",
#'     length_integers = list(
#'       week = 2,
#'       data_availability_week = 2,
#'       reception_week = 2
#'     )
#'   ) %>%
#'   role_playing_dimension(
#'     dim_names = c("when", "when_received", "when_available"),
#'     name = "when_common",
#'     attributes = c("date", "week", "year")
#'   )
#'
#' @format A `star_schema` object.
"st_mrs_cause"

#' Star Schema for Mortality Reporting System by Cause Test
#'
#' Star Schema for the Mortality Reporting System considering the cause
#' classification data test.
#'
#' @examples
#' # Defined by:
#'
#' library(tidyr)
#'
#' st_mrs_cause_test <- star_schema(mrs_cause_test, dm_mrs_cause) %>%
#'   snake_case() %>%
#'   character_dimensions(
#'     NA_replacement_value = "Unknown",
#'     length_integers = list(
#'       week = 2,
#'       data_availability_week = 2,
#'       reception_week = 2
#'     )
#'   ) %>%
#'   role_playing_dimension(
#'     dim_names = c("when", "when_received", "when_available"),
#'     name = "when_common",
#'     attributes = c("date", "week", "year")
#'   )
#'
#' @format A `star_schema` object.
"st_mrs_cause_test"

#' Star Schema for Mortality Reporting System by Cause for Week Test
#'
#' Star Schema for the Mortality Reporting System considering the cause
#' classification data test, for week 4 of 1962. It also includes some isolated
#' data from previous weeks that is supposed to be additional data not
#' considered before.
#'
#' @examples
#' # Defined by:
#'
#' library(tidyr)
#'
#' st_mrs_cause_w_test <- star_schema(mrs_cause_w_test, dm_mrs_cause) %>%
#'   snake_case() %>%
#'   character_dimensions(
#'     NA_replacement_value = "Unknown",
#'     length_integers = list(
#'       week = 2,
#'       data_availability_week = 2,
#'       reception_week = 2
#'     )
#'   ) %>%
#'   role_playing_dimension(
#'     dim_names = c("when", "when_received", "when_available"),
#'     name = "when_common",
#'     attributes = c("date", "week", "year")
#'   )
#'
#' @format A `star_schema` object.
"st_mrs_cause_w_test"

#' Star Schema for Mortality Reporting System by Cause for Week 10
#'
#' Star Schema for the Mortality Reporting System considering the cause
#' classification data, for week 10 of 1962. It also includes some isolated data
#' from previous weeks that is supposed to be additional data not considered
#' before.
#'
#' @examples
#' # Defined by:
#'
#' library(tidyr)
#'
#' st_mrs_cause_w10 <- star_schema(mrs_cause_w10, dm_mrs_cause) %>%
#'   snake_case() %>%
#'   character_dimensions(
#'     NA_replacement_value = "Unknown",
#'     length_integers = list(
#'       week = 2,
#'       data_availability_week = 2,
#'       reception_week = 2
#'     )
#'   ) %>%
#'   role_playing_dimension(
#'     dim_names = c("when", "when_received", "when_available"),
#'     name = "when_common",
#'     attributes = c("date", "week", "year")
#'   )
#'
#' @format A `star_schema` object.
"st_mrs_cause_w10"

#' Star Schema for Mortality Reporting System by Cause for Week 11
#'
#' Star Schema for the Mortality Reporting System considering the cause
#' classification data, for week 11 of 1962. It also includes some isolated data
#' from previous weeks that is supposed to be additional data not considered
#' before.
#'
#' @examples
#' # Defined by:
#'
#' library(tidyr)
#'
#' st_mrs_cause_w11 <- star_schema(mrs_cause_w11, dm_mrs_cause) %>%
#'   snake_case() %>%
#'   character_dimensions(
#'     NA_replacement_value = "Unknown",
#'     length_integers = list(
#'       week = 2,
#'       data_availability_week = 2,
#'       reception_week = 2
#'     )
#'   ) %>%
#'   role_playing_dimension(
#'     dim_names = c("when", "when_received", "when_available"),
#'     name = "when_common",
#'     attributes = c("date", "week", "year")
#'   )
#'
#' @format A `star_schema` object.
"st_mrs_cause_w11"

#' Constellation for Mortality Reporting System
#'
#' Constellation for the Mortality Reporting System considering age and cause
#' classification.
#'
#' @examples
#' # Defined by:
#'
#' ct_mrs <- constellation(list(st_mrs_age, st_mrs_cause), name = "mrs")
#'
#' @format A `constellation` object.
"ct_mrs"

#' Constellation for Mortality Reporting System Test
#'
#' Constellation for the Mortality Reporting System considering age and cause
#' classification data test.
#'
#' @examples
#' # Defined by:
#'
#' ct_mrs_test <-
#'   constellation(list(st_mrs_age_test, st_mrs_cause_test), name = "mrs_test")
#'
#' @format A `constellation` object.
"ct_mrs_test"


#' Updates for the Star Schema for Mortality Reporting System by Age
#'
#' Example of updates on some dimensions of the star schema for Mortality Reporting
#' System by age.
#'
#' @examples
#' # Defined by:
#'
#' library(tidyr)
#'
#' (dim_names <- st_mrs_age %>%
#'     get_dimension_names())
#'
#' where <- st_mrs_age %>%
#'   get_dimension("where")
#'
#' when <- st_mrs_age %>%
#'   get_dimension("when")
#'
#' who <- st_mrs_age %>%
#'   get_dimension("who")
#'
#' updates_st_mrs_age <- record_update_set() %>%
#'   update_selection_general(
#'     dimension = where,
#'     columns_old = c("state", "city"),
#'     old_values = c("CT", "Bridgepor"),
#'     columns_new = c("city"),
#'     new_values = c("Bridgeport")
#'   ) %>%
#'   match_records(dimension = when,
#'                 old = 37,
#'                 new = 36) %>%
#'   update_record(
#'     dimension = when,
#'     old = 73,
#'     values = c("1962-02-17", "07", "1962")
#'   ) %>%
#'   update_selection(
#'     dimension = who,
#'     columns = c("age_range"),
#'     old_values = c("<1 year"),
#'     new_values = c("1: <1 year")
#'   ) %>%
#'   update_selection(
#'     dimension = who,
#'     columns = c("age_range"),
#'     old_values = c("1-24 years"),
#'     new_values = c("2: 1-24 years")
#'   ) %>%
#'   update_selection(
#'     dimension = who,
#'     columns = c("age_range"),
#'     old_values = c("25-44 years"),
#'     new_values = c("3: 25-44 years")
#'   ) %>%
#'   update_selection(
#'     dimension = who,
#'     columns = c("age_range"),
#'     old_values = c("45-64 years"),
#'     new_values = c("4: 45-64 years")
#'   ) %>%
#'   update_selection(
#'     dimension = who,
#'     columns = c("age_range"),
#'     old_values = c("65+ years"),
#'     new_values = c("5: 65+ years")
#'   )
#'
#' @format A `record_update_set` object.
"updates_st_mrs_age"

#' Updates for the Star Schema for Mortality Reporting System by Age Test
#'
#' Example of updates on some dimensions of the star schema for Mortality Reporting
#' System by age test.
#'
#' @examples
#' # Defined by:
#'
#' library(tidyr)
#'
#' (dim_names <- st_mrs_age_test %>%
#'     get_dimension_names())
#'
#' where <- st_mrs_age_test %>%
#'   get_dimension("where")
#'
#' when <- st_mrs_age_test %>%
#'   get_dimension("when")
#'
#' who <- st_mrs_age_test %>%
#'   get_dimension("who")
#'
#' updates_st_mrs_age_test <- record_update_set() %>%
#'   update_selection_general(
#'     dimension = where,
#'     columns_old = c("state", "city"),
#'     old_values = c("CT", "Bridgepor"),
#'     columns_new = c("city"),
#'     new_values = c("Bridgeport")
#'   ) %>%
#'   match_records(dimension = when,
#'                 old = 4,
#'                 new = 3) %>%
#'   update_record(
#'     dimension = when,
#'     old = 9,
#'     values = c("1962-01-20", "03", "1962")
#'   ) %>%
#'   update_selection(
#'     dimension = who,
#'     columns = c("age_range"),
#'     old_values = c("<1 year"),
#'     new_values = c("1: <1 year")
#'   ) %>%
#'   update_selection(
#'     dimension = who,
#'     columns = c("age_range"),
#'     old_values = c("1-24 years"),
#'     new_values = c("2: 1-24 years")
#'   ) %>%
#'   update_selection(
#'     dimension = who,
#'     columns = c("age_range"),
#'     old_values = c("25-44 years"),
#'     new_values = c("3: 25-44 years")
#'   ) %>%
#'   update_selection(
#'     dimension = who,
#'     columns = c("age_range"),
#'     old_values = c("45-64 years"),
#'     new_values = c("4: 45-64 years")
#'   ) %>%
#'   update_selection(
#'     dimension = who,
#'     columns = c("age_range"),
#'     old_values = c("65+ years"),
#'     new_values = c("5: 65+ years")
#'   )
#'
#' @format A `record_update_set` object.
"updates_st_mrs_age_test"

#' Multistar for Mortality Reporting System
#'
#' Multistar for the Mortality Reporting System considering age and cause
#' classification. It is the result obtained in the vignette.
#'
#' @examples
#' # Defined by:
#'
#' library(tidyr)
#'
#' ms_mrs <- ct_mrs %>%
#'   constellation_as_multistar()
#'
#' @format A `multistar` object.
"ms_mrs"

#' Multistar for Mortality Reporting System Test
#'
#' Multistar for the Mortality Reporting System considering age and cause
#' classification data test.
#'
#' @examples
#' # Defined by:
#'
#' library(tidyr)
#'
#' ms_mrs_test <- ct_mrs_test %>%
#'   constellation_as_multistar()
#'
#' @format A `multistar` object.
"ms_mrs_test"


#' Modelling the long-term health impacts of air pollution in London
#'
#' Estimation of the long-term health impacts of exposure to air pollution in
#' London from 2016 to 2050.
#'
#' The original dataset contains 68 files, corresponding to 34 London areas and
#' 2 pollutants: pollutant and zone are indicated in the name of each file. Each
#' file has several sheets with different variables. It has been transformed
#' into a flat table considering a single variable and defining the area and the
#' pollutant as columns.
#'
#' @format A `tibble`.
#' @source
#'   \url{https://data.world/datagov-uk/fd864906-8456-46a8-9a01-0dcb2dbd87b9}
"ft_datagov_uk"


#' London Boroughs
#'
#' Classification of London's boroughs into zones and sub-regions.
#'
#' @format A `tibble`.
#' @source \url{https://data.london.gov.uk/dataset/london-borough-profiles} and
#' \url{https://en.wikipedia.org/wiki/List_of_sub-regions_used_in_the_London_Plan}
"ft_london_boroughs"


#' USA States
#'
#' Name and abbreviation of US states.
#'
#' @format A `tibble`.
#' @source \url{https://www.census.gov/geographies/mapping-files/time-series/geo/carto-boundary-file.html}
"ft_usa_states"


#' USA City and County
#'
#' City, state and county for US cities. It only includes those that appear in
#' the Mortality Reporting System.
#'
#' @format A `tibble`.
#' @source \url{https://www.census.gov/geographies/mapping-files/time-series/geo/carto-boundary-file.html}
"ft_usa_city_county"



