% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dimensional_query_run_query.R
\name{run_query}
\alias{run_query}
\alias{run_query.dimensional_query}
\title{Run query}
\usage{
run_query(dq, unify_by_grain = TRUE)

\method{run_query}{dimensional_query}(dq, unify_by_grain = TRUE)
}
\arguments{
\item{dq}{A \code{dimensional_query} object.}

\item{unify_by_grain}{A boolean, unify facts with the same grain.}
}
\value{
A \code{dimensional_query} object.
}
\description{
Once we have selected the facts, dimensions and defined the conditions on the
instances, we can execute the query to obtain the result.
}
\details{
As an option, we can indicate if we do not want to unify the facts in the
case of having the same grain.
}
\examples{
library(tidyr)

ms <- dimensional_query(ms_mrs) \%>\%
  select_dimension(name = "where",
                   attributes = c("city", "state")) \%>\%
  select_dimension(name = "when",
                   attributes = c("when_happened_year")) \%>\%
  select_fact(
    name = "mrs_age",
    measures = c("n_deaths"),
    agg_functions = c("MAX")
  ) \%>\%
  select_fact(
    name = "mrs_cause",
    measures = c("pneumonia_and_influenza_deaths", "other_deaths")
  ) \%>\%
  filter_dimension(name = "when", when_happened_week <= "03") \%>\%
  filter_dimension(name = "where", city == "Boston") \%>\%
  run_query()

}
\seealso{


Other query functions: 
\code{\link{dimensional_query}()},
\code{\link{filter_dimension}()},
\code{\link{select_dimension}()},
\code{\link{select_fact}()}
}
\concept{query functions}
