% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{updates_st_mrs_age_test}
\alias{updates_st_mrs_age_test}
\title{Updates for the Star Schema for Mortality Reporting System by Age Test}
\format{
A \code{record_update_set} object.
}
\usage{
updates_st_mrs_age_test
}
\description{
Example of updates on some dimensions of the star schema for Mortality Reporting
System by age test.
}
\examples{
# Defined by:

library(tidyr)

(dim_names <- st_mrs_age_test \%>\%
    get_dimension_names())

where <- st_mrs_age_test \%>\%
  get_dimension("where")

when <- st_mrs_age_test \%>\%
  get_dimension("when")

who <- st_mrs_age_test \%>\%
  get_dimension("who")

updates_st_mrs_age_test <- record_update_set() \%>\%
  update_selection_general(
    dimension = where,
    columns_old = c("state", "city"),
    old_values = c("CT", "Bridgepor"),
    columns_new = c("city"),
    new_values = c("Bridgeport")
  ) \%>\%
  match_records(dimension = when,
                old = 4,
                new = 3) \%>\%
  update_record(
    dimension = when,
    old = 9,
    values = c("1962-01-20", "03", "1962")
  ) \%>\%
  update_selection(
    dimension = who,
    columns = c("age_range"),
    old_values = c("<1 year"),
    new_values = c("1: <1 year")
  ) \%>\%
  update_selection(
    dimension = who,
    columns = c("age_range"),
    old_values = c("1-24 years"),
    new_values = c("2: 1-24 years")
  ) \%>\%
  update_selection(
    dimension = who,
    columns = c("age_range"),
    old_values = c("25-44 years"),
    new_values = c("3: 25-44 years")
  ) \%>\%
  update_selection(
    dimension = who,
    columns = c("age_range"),
    old_values = c("45-64 years"),
    new_values = c("4: 45-64 years")
  ) \%>\%
  update_selection(
    dimension = who,
    columns = c("age_range"),
    old_values = c("65+ years"),
    new_values = c("5: 65+ years")
  )

}
\keyword{datasets}
