% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/functions.R
\name{predict.starnet}
\alias{predict.starnet}
\title{Makes Predictions}
\usage{
\method{predict}{starnet}(object, newx, type = "response", nzero = NULL, ...)
}
\arguments{
\item{object}{\link[starnet]{starnet} object}

\item{newx}{covariates\strong{:}
numeric matrix with \eqn{n} rows (samples)
and \eqn{p} columns (variables)}

\item{type}{character "link" or "response"}

\item{nzero}{maximum number of non-zero coefficients\strong{:}
positive integer, or \code{NULL}}

\item{...}{further arguments (not applicable)}
}
\value{
Matrix of predicted values, with samples in the rows,
and models in the columns. Included models are
\code{alpha} (fixed elastic net),
\code{ridge} (i.e. \code{alpha0}),
\code{lasso} (i.e. \code{alpha1}),
\code{tune} (tuned elastic net),
\code{stack} (stacked elastic net),
and \code{none} (intercept-only model).
}
\description{
Predicts outcome from features with stacked model.
}
\examples{
set.seed(1)
n <- 40; p <- 50
y <- rnorm(n=n)
X <- matrix(rnorm(n*p),nrow=n,ncol=p)
object <- starnet(y=y,X=X)
y_hat <- predict(object,newx=X[c(1),,drop=FALSE])

}
