% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PMXStanFit.R
\name{gofplot}
\alias{gofplot}
\title{Overall goodness-of-fit plots.}
\usage{
gofplot(fit)
}
\arguments{
\item{fit}{a \code{PMXStanFit} object.}
}
\description{
Provides a convenient and fast way to implement three commonly used goodness-of-fit plotting over the 
whole population across the input data.
}
\details{
This function is a generic version covering three methods for the \code{\link{PMXStanFit}} class: 
\code{plot.gof.pred.obs()}, \code{plot.gof.pred.rsd()}, and \code{plot.gof.idv()}. They plot
medians of predictions vs. observations, the differences between medians of predicion and observations
vs. predictions, and time profiles of the prediction medians and 95% predictive intervals on top
of observations, repectively.
}
\value{No return value, called for side effects}
\examples{
\donttest{
m1 <- PMXStanModel(path = tempfile("pk_m1"), pk.struct = "1-cmpt", compile=TRUE)

data("examples_data")
dat <- prepareInputData(data.source = d1_nm_poppk, model = m1)

fit <- PMXStanFit(m1, dat, iter=100, chains=1)

fit$plot.gof.pred.obs()
fit$plot.gof.idv()
fit$plot.gof.pred.rsd()

gofplot(fit)
}
}
\seealso{
\code{\link{PMXStanFit}} for the methods \code{plot.gof.pred.obs()}, \code{plot.gof.idv()}, 
and \code{plot.gof.pred.rsd()}.
}

