% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/invinteraction.R
\name{invinteraction}
\alias{invinteraction}
\title{Split an interaction'ed factor back into seperate variables}
\usage{
invinteraction(fac, ..., sep = ".")
}
\arguments{
\item{fac}{the factor to split}

\item{...}{optional, names for variables}

\item{sep}{the seperator between levels}
}
\value{
a data.frame of factors
}
\description{
Inverse of \code{interaction}
}
\section{Changes}{


Refactored to process the levels vector, rather than entire factor vector.
}

\examples{

f1 <- gl(2, 3)
f2 <- gl(3, 2)
invinteraction(f1:f2, sep=':') 

ppl <- interaction(
  eyes = as.factor(sample(colors(), 10)),
  hair = as.factor(sample(colors(), 10))
  )
str(invinteraction(ppl, "eyes", "hair"))

}
\references{
\url{http://stackoverflow.com/a/10521926/986793}
}
\seealso{
\code{\link[base]{interaction}}
}
\author{
\href{http://stackoverflow.com/users/1855677/42}{42}, Neal Fultz
}
