% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/parafac_functions.R
\name{eempf_varimp}
\alias{eempf_varimp}
\title{Calculate the importance of each component.}
\usage{
eempf_varimp(
  pfmodel,
  eem_list,
  cores = parallel::detectCores(logical = FALSE),
  ...
)
}
\arguments{
\item{pfmodel}{model of class parafac}

\item{eem_list}{eemlist used to calculate that model}

\item{cores}{cores to be used for the calculation}

\item{...}{other aruments passed to eem_parafac}
}
\value{
numeric vector, values are in the same order of the components in the supplied model.
}
\description{
Calculate the importance of each component.
}
\details{
The importance of each variable is calculated by means of creating a model without a specific component and calculating the difference between the original R-squared and the one with the left out component. The derived values state the loss in model fit if one component is not used in the modeling process. For the creation of the new models, the exact components of the original model are used.
}
\examples{
\donttest{
data(pfmodel)
data(eem_list)

eempf_varimp(pf4[[1]],eem_list)
}
}
