% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/parafac_functions.R
\name{eempf4analysis}
\alias{eempf4analysis}
\title{Create table of PARAFAC components and (optionally) EEM peaks and indices as well as absorbance slope parameters.}
\usage{
eempf4analysis(pfmodel, eem_list = NULL, absorbance = NULL, cuvl = NULL,
  n = 4, export = NULL, ...)
}
\arguments{
\item{pfmodel}{PARAFAC model where loadings of the components are extracted}

\item{eem_list}{optional eemlist used for peak and indices calculation}

\item{absorbance}{optional absorbance table used for absorbance slope parameter calculation}

\item{cuvl}{optional cuvette length of absorbance data in cm}

\item{n}{optional size of moving window in nm for data smoothing in advance of peak picking}

\item{export}{optional file path of csv or txt table where data is exported}

\item{...}{additional parameters passed to \code{\link[utils]{write.table}}}
}
\value{
data frame
}
\description{
Please refer to \code{\link[eemR]{eem_biological_index}}, \code{\link[eemR]{eem_coble_peaks}}, \code{\link[eemR]{eem_fluorescence_index}}, \code{\link[eemR]{eem_biological_index}} and \code{\link[staRdom]{abs_parms}} for details on the certain values
}
\examples{
\donttest{
data(eem_list)
data(pfres_comps2)
data(abs_data)

results <- eempf4analysis(pfmodel = pfres_comps2[[2]],
                          eem_list = eem_list, absorbance = abs_data,
                          cuvl = 5, n = 4)
                          }
}
