% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/parafac_functions.R
\name{eempf_fit_sample}
\alias{eempf_fit_sample}
\title{Fitting amounts of components of any samples to a certain model}
\usage{
eempf_fit_sample(cp_out, eem, control = list(maxit = 10^3),
  method = "L-BFGS-B", lower = rep(0, comps), ...)
}
\arguments{
\item{cp_out}{parafac model}

\item{eem}{eem to be fitted}

\item{control}{control parameters passed to \code{\link[stats]{optim}}}

\item{method}{method used in \code{\link[stats]{optim}}}

\item{lower}{lower boundaries in \code{\link[stats]{optim}}, amount of a component should not be negative}

\item{...}{other parmeters passed on to \code{\link[stats]{optim}}}
}
\value{
vector containing amounts of components
}
\description{
Fitting amounts of components of any samples to a certain model
}
\details{
For parameters concerning \code{\link[stats]{optim}} please see according help.
}
\examples{
\donttest{
data(eem_list)
data(pfres_comps1)

eem_fit <- eempf_fit_sample(pfres_comps2[[3]],eem_list[[1]])
}
}
