% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/parafac_plot_functions.R
\name{eempf_residuals_plot}
\alias{eempf_residuals_plot}
\title{Plot samples by means of whole sample, each single component and residuum}
\usage{
eempf_residuals_plot(pfmodel, eem_list, res_data = NULL, spp = 5,
  select = NULL, residuals_only = FALSE,
  cores = parallel::detectCores(logical = FALSE), contour = FALSE)
}
\arguments{
\item{pfmodel}{object of class parafac containing the generated model}

\item{eem_list}{object of class eemlist with all the samples that should be plotted}

\item{res_data}{optional, data of sample residuals related to the model, output from \code{\link[staRdom]{eempf_residuals}}}

\item{spp}{optional, samples per plot}

\item{select}{optional, character vector of samples you want to plot}

\item{residuals_only}{plot only residuals}

\item{cores}{number of cores to use for parallel processing}

\item{contour}{logical, states whether contours should be plotted}
}
\value{
several ggplot objects
}
\description{
A raster of plots is created. Each column shows one sample. The top n rows show the n components from the model according their occurance in the certain samples. The second last row shows the residual, not covered by any component in the model and the last row shows the whole sample.
}
\details{
eem_list may contain samples not used for modelling. Calculation is done by \code{\link[staRdom]{A_missing}}. This especially interesting if outliers are excluded prior modelling and should be evaluated again afterwards.
}
\examples{
\donttest{
data(eem_list)
data(pf_models)

eempf_residuals_plot(pf4[[1]],eem_list)
}

}
