% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.str.R
\name{plot.STR}
\alias{plot.STR}
\title{Plots the results of decomposition}
\usage{
\method{plot}{STR}(
  x,
  xTime = NULL,
  dataPanels = 1,
  predictorPanels = as.list(seq_along(x$output$predictors)),
  randomPanels = length(x$output$predictors) + 1,
  forecastPanels = length(x$output$predictors) + 2,
  dataColor = "black",
  predictorColors = rep("red", length(x$output$predictors)),
  randomColor = "red",
  forecastColor = "blue",
  vLines = NULL,
  xlab = "Time",
  main = ifelse(x$method \%in\% c("STR", "STRmodel"), "STR decomposition",
    "Robust STR decomposition"),
  showLegend = TRUE,
  ...
)
}
\arguments{
\item{x}{Result of STR decomposition.}

\item{xTime}{Times for data to plot.}

\item{dataPanels}{Vector of panel numbers in which to plot the original data. Set to \code{NULL} to not show data.}

\item{predictorPanels}{A list of vectors of numbers where every such vector describes which panels should be used for plotting the corresponding predictor.}

\item{randomPanels}{Vector of panel numbers in which to plot the residuals.  Set to \code{NULL} to not show residuals.}

\item{forecastPanels}{Vector of panel numbers in which to plot the fit/forecast.  Set to \code{NULL} to not show forecasts.}

\item{dataColor}{Color to plot data.}

\item{predictorColors}{Vector of colors to plot components corresponding to the predictors.}

\item{randomColor}{Color to plot the residuals.}

\item{forecastColor}{Color to plot the fit/forecast.}

\item{vLines}{Vector of times where vertical lines will be plotted.}

\item{xlab}{Label for horizontal axis.}

\item{main}{Main heading for plot.}

\item{showLegend}{When \code{TRUE} (default) legend is shown at top of plot.}

\item{...}{Other parameters to be passed directly to plot and lines functions in the implementation.}
}
\description{
\code{plot.STR} plots results of STR decomposition.
}
\examples{
\donttest{

fit <- AutoSTR(log(grocery))
plot(fit, forecastPanels=0, randomColor="DarkGreen", vLines = 2000:2010, lwd = 2)

}
}
\seealso{
\code{\link{STRmodel}}, \code{\link{RSTRmodel}}, \code{\link{STR}}, \code{\link{AutoSTR}}
}
\author{
Alexander Dokumentov
}
