% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotMethods.R, R/predict.R, R/printMethods.R
\name{plot.stvarpred}
\alias{plot.stvarpred}
\alias{predict.stvar}
\alias{print.stvarpred}
\title{Predict method for class 'stvar' objects}
\usage{
\method{plot}{stvarpred}(x, ..., nt, trans_weights = TRUE)

\method{predict}{stvar}(
  object,
  ...,
  nsteps,
  nsim = 1000,
  pi = c(0.95, 0.8),
  pred_type = c("mean", "median"),
  exo_weights = NULL
)

\method{print}{stvarpred}(x, ..., digits = 2)
}
\arguments{
\item{x}{object of class \code{'stvarpred'}}

\item{...}{currently not used.}

\item{nt}{a positive integer specifying the number of observations to be plotted
along with the forecast.}

\item{trans_weights}{should forecasts for transition weights be plotted?}

\item{object}{an object of class \code{'stvar'}.}

\item{nsteps}{how many steps ahead should be predicted?}

\item{nsim}{to how many independent simulations should the forecast be based on?}

\item{pi}{a numeric vector specifying the confidence levels of the prediction intervals.}

\item{pred_type}{should the pointforecast be based on sample "median" or "mean"?}

\item{exo_weights}{if \code{weight_function="exogenous"}, provide a size \eqn{(nsteps x M)} matrix of exogenous
transition weights for the regimes: \code{[step, m]} for \eqn{step} steps ahead and regime \eqn{m} weight. Ignored
if \code{weight_function!="exogenous"}.}

\item{digits}{the number of decimals to print}
}
\value{
Returns a class '\code{stvarpred}' object containing, among the specifications,...
 \describe{
   \item{$pred}{Point forecasts}
   \item{$pred_ints}{Prediction intervals, as \code{[, , d]}.}
   \item{$trans_pred}{Point forecasts for the transition weights}
   \item{$trans_pred_ints}{Individual prediction intervals for transition weights, as \code{[, , m]}, m=1,..,M.}
 }
}
\description{
\code{predict.stvar} is a predict method for class \code{'stvar'} objects.
}
\details{
The forecasts are computed by simulating multiple sample paths of the future observations and
  using the sample medians or means as point forecasts and empirical quantiles as prediction intervals.
}
\section{Functions}{
\itemize{
\item \code{plot(stvarpred)}: predict method

\item \code{print(stvarpred)}: print method

}}
\examples{
 # p=2, M=2, d=2, Gaussian relative dens weights
 theta_222relg <- c(0.356914, 0.107436, 0.356386, 0.08633, 0.13996, 0.035172,
   -0.164575, 0.386816, 0.451675, 0.013086, 0.227882, 0.336084, 0.239257, 0.024173,
   -0.021209, 0.707502, 0.063322, 0.027287, 0.009182, 0.197066, 0.205831, 0.005157,
   0.025877, 1.092094, -0.009327, 0.116449, 0.592446)
 mod222relg <- STVAR(data=gdpdef, p=2, M=2, d=2, params=theta_222relg,
   weight_function="relative_dens")

 # Predict 10 steps ahead, point forecast based on the conditional
 # mean and 90\% prediction intervals; prediction based on 100 sample paths:
 pred1 <- predict(mod222relg, nsteps=10, nsim=100, pi=0.9, pred_type="mean")
 pred1
 plot(pred1)

 # Predict 7 steps ahead, point forecast based on median and  90\%, 80\%,
 # and 70\% prediction intervals; prediction based on 80 sample paths:
 pred2 <- predict(mod222relg, nsteps=7, nsim=80, pi=c(0.9, 0.8, 0.7),
  pred_type="median")
 pred2
 plot(pred2)
}
\references{
\itemize{
   \item Anderson H., Vahid F. 1998. Testing multiple equation systems for common nonlinear components.
     \emph{Journal of Econometrics}, \strong{84}:1, 1-36.
   \item Hansen B.E. 1994. Autoregressive Conditional Density estimation.
     \emph{Journal of Econometrics}, \strong{35}:3, 705-730.
   \item Kheifets I.L., Saikkonen P.J. 2020. Stationarity and ergodicity of Vector STAR models.
     \emph{International Economic Review}, \strong{35}:3, 407-414.
   \item Lanne M., Virolainen S. 2025. A Gaussian smooth transition vector autoregressive model:
      An application to the macroeconomic effects of severe weather shocks. Unpublished working
      paper, available as arXiv:2403.14216.
   \item Lütkepohl H. 2005. New Introduction to Multiple Time Series Analysis,
         \emph{Springer}.
   \item McElroy T. 2017. Computation of vector ARMA autocovariances.
         \emph{Statistics and Probability Letters}, \strong{124}, 92-96.
   \item Kilian L., Lütkepohl H. 20017. Structural Vector Autoregressive Analysis. 1st edition.
     \emph{Cambridge University Press}, Cambridge.
   \item Tsay R. 1998. Testing and Modeling Multivariate Threshold Models.
     \emph{Journal of the American Statistical Association}, \strong{93}:443, 1188-1202.
   \item Virolainen S. 2025. Identification by non-Gaussianity in structural threshold and
      smooth transition vector autoregressive models. Unpublished working
      paper, available as arXiv:2404.19707.
 }
}
\seealso{
\code{\link{simulate.stvar}}
}
