# Generated by using Rcpp::compileAttributes() -> do not edit by hand
# Generator token: 10BE3573-1514-4C36-9D1C-5A225CD40393

#' @name Gaussian_densities_Cpp
#' @title Calculate log multivariate Gaussian densities
#' @description Calculates logs of multivariate Gaussian densities with varying mean
#'   and varying covariance matrix AND EXCLUDING the constant term of the density
#'   (the constant is calculated and added in R code). The varying conditional covariance
#'   matrix is calculated within the function from the regime covariance matrices and
#'   transition weights.
#'
#' @param obs a \eqn{(T \times d)} matrix such that the \eqn{i}th row contains the vector
#'  \eqn{y_{i}=(y_{1i},...,y_{di})} \eqn{(dx1)}. That is, the initial values are
#'  excluded but the last observations is included.
#' @param means a \eqn{(T \times d)} matrix such that the \eqn{i}th row contains the
#'   conditional mean of the process \eqn{\mu_{y,i}}.
#' @param covmats a \eqn{(d \times d \times M)} array such that the slice \code{[, , m]}
#'   contains the conditional covariance matrix of regime m.
#' @param alpha_mt a \eqn{(T \times M)} matrix such that \code{[t, m]} contains the time t
#'   transition weights of the \eqn{m}th regime.
#' @return a numeric vector containing the multivariate Gaussian densities, excluding the constant term.
#' @keywords internal
Gaussian_densities_Cpp <- function(obs, means, covmats, alpha_mt) {
    .Call('_sstvars_Gaussian_densities_Cpp', PACKAGE = 'sstvars', obs, means, covmats, alpha_mt)
}

#' @name Gaussian_densities_const_Cpp
#' @title Calculate log multivariate Gaussian densities
#' @description Calculates logs of multivariate Gaussian densities with constant mean
#'   and constant covariance matrix AND EXCLUDING the constant term of the density
#'   (the constant is calculated and added in R code).
#'
#' @param obs a \eqn{(T \times dp)} matrix such that the i:th row contains the vector
#'  \eqn{(y_{i-1}',...,y_{i-p}')} \eqn{((dp)x1)}, where \eqn{y_{i}=(y_{1i},...,y_{di})}
#'  \eqn{(dx1)}. That is, the initial values are included but the last observations not.
#' @param mean the \eqn{((dp)x1)} mean vector, \code{rep(all_mu[,m], times=p)}, that is the same for
#'  all observations.
#' @param cholcovmat the \eqn{(dp \times dp)} covariance matrix that is the same for all observations.
#' @details This function is used in the relative density transition weights with Gaussian regimes.
#' @return a numeric vector containing the multivariate Gaussian densities, excluding the constant term.
#' @keywords internal
Gaussian_densities_const_Cpp <- function(obs, mean, cholcovmat) {
    .Call('_sstvars_Gaussian_densities_const_Cpp', PACKAGE = 'sstvars', obs, mean, cholcovmat)
}

#' @name Student_densities_Cpp
#' @title Calculate log multivariate Student's t densities
#' @description Calculates logs of multivariate Student t densities with varying mean
#'   and varying covariance matrix AND EXCLUDING the constant term of the density
#'   (the constant is calculated and added in R code). The varying conditional covariance
#'   matrix is calculated within the function from the regime covariance matrices and
#'   transition weights.
#'
#' @inheritParams Gaussian_densities_Cpp
#' @param df the degrees of freedom parameter value (assumed larger than two).
#' @details Note that the parametrization is with the covariance matrix and not the scale matrix.
#' @return a numeric vector containing the multivariate Student's t densities, excluding the constant term.
#' @keywords internal
Student_densities_Cpp <- function(obs, means, covmats, alpha_mt, df) {
    .Call('_sstvars_Student_densities_Cpp', PACKAGE = 'sstvars', obs, means, covmats, alpha_mt, df)
}

#' @name check_Bt_Cpp
#' @title Check Matrix B Invertibility with C++ (Internal Function)
#'
#' @description This internal function takes a cube of matrices (\code{all_Omegas}),
#' a matrix of weights (\code{alpha_mt}), and a numerical tolerance (\code{posdef_tol})
#' to check the invertibility of weighted sums of the matrices in the cube. For each row
#' in \code{alpha_mt}, it computes a weighted sum of matrices, and checks if this sum is
#' invertible by verifying that its determinant is not within the specified tolerance of zero.
#'
#' @param all_Omegas A cube (3D array) of impact matrices, with each slice being an inveritble square matrix.
#' @param alpha_mt A matrix of weights, with as many columns as there are slices in \code{all_Omegas}.
#' @param posdef_tol A strictly positive small number used as a tolerance for checking
#'        the invertibility of the matrix. The matrix is considered non-invertible if
#'        its determinant is less than this tolerance.
#'
#' @return A boolean value: `TRUE` if all weighted sums are invertible up to the specified
#'         tolerance, `FALSE` otherwise.
#'
#' @keywords internal
check_Bt_Cpp <- function(all_Omegas, alpha_mt, posdef_tol) {
    .Call('_sstvars_check_Bt_Cpp', PACKAGE = 'sstvars', all_Omegas, alpha_mt, posdef_tol)
}

#' @name get_Bt_Cpp
#' @title Calculate the impact matrix \eqn{B_t} for all \eqn{t} for models with a non-Gaussian
#'  conditional distribution with mutually independent shocks.
#'
#' @description This internal function takes a cube of matrices (\code{all_Omegas}) and a matrix of weights (\code{alpha_mt}),
#' and calculates the weighted sums of the matrices in the cube. For each row in \code{alpha_mt}, it computes
#' a weighted sum of matrices, and returns the
#'
#' @inheritParams check_Bt_Cpp
#'
#' @return An arma::cube value (3D array in R) such that each slice contains the weighted sum of the matrices,
#'   i.e, the impact matrix \eqn{B_t} for all \eqn{t}.
#'
#' @keywords internal
get_Bt_Cpp <- function(all_Omegas, alpha_mt) {
    .Call('_sstvars_get_Bt_Cpp', PACKAGE = 'sstvars', all_Omegas, alpha_mt)
}

#' @name get_mu_yt_Cpp
#' @title Calculate the conditional means of the process
#' @description Calculates the conditional means \eqn{\mu_{y,t}} of the process
#'
#' @param obs a \eqn{(T \times dp)} matrix such that the i:th row contains the vector
#'   \eqn{(y_{i-1},...,y_{i-p})} \eqn{((dp)x1)}, where \eqn{y_{i}=(y_{1i},...,y_{di})}
#'   \eqn{(dx1)}. That is, the initial values are included but the last observations not.
#' @param all_phi0 a \eqn{(d \times M)} matrix such that the m:th column contains the
#'   intercept parameters of the m:th regime.
#' @param all_A a \eqn{(d \times dp \times M)} array such that the slice \code{[, , m]}
#'   contains the AR matrices of the m:th regime cbinded together: \eqn{[A_{m,1}:...:A_{m,p}]}.
#' @param alpha_mt a \eqn{(T \times M)} matrix such that \code{[t, m]} contains the time t
#'   transition weights of the m:th regime.
#' @return a \eqn{(T \times d)} matrix such that the i:th row contains the conditional
#'   mean of the process.
#' @keywords internal
get_mu_yt_Cpp <- function(obs, all_phi0, all_A, alpha_mt) {
    .Call('_sstvars_get_mu_yt_Cpp', PACKAGE = 'sstvars', obs, all_phi0, all_A, alpha_mt)
}

#' @name ind_Student_densities_Cpp
#' @title Calculate log independent multivariate Student's t densities
#' @description Calculates logs of independent multivariate Student t densities with varying mean
#'   and impact matrix AND EXCLUDING the constant term of the density
#'   (the constant is calculated and added in R code). The varying impact matrix is calculated within
#'   the function from the impact matrices of the regimes and transition weights.
#'
#' @inheritParams Student_densities_Cpp
#' @inheritParams loglikelihood
#' @param impact_matrices a size \eqn{d\times d \times M} \code{arma::cube} (3D array in R), where each slice contains an
#'  invertible (d x d) impact matrix of each regime.
#' @param distpars a numeric vector of length \eqn{d}, containing the degrees of freedom parameters for each component.
#' @details Returns \code{minval} if the impact matrix \eqn{B_t} is not invertible for some t up to the numerical tolerance
#'  \code{posdef_tol}.
#' @return A numeric vector of length \eqn{T}, where each element represents the computed density component for
#'  the corresponding observation.
#' @keywords internal
ind_Student_densities_Cpp <- function(obs, means, impact_matrices, alpha_mt, distpars, minval, posdef_tol) {
    .Call('_sstvars_ind_Student_densities_Cpp', PACKAGE = 'sstvars', obs, means, impact_matrices, alpha_mt, distpars, minval, posdef_tol)
}

#' @name ind_skewed_t_densities_Cpp
#' @title Calculate log independent multivariate skewed t densities
#' @description Calculates logs of independent multivariate skewed t densities with varying mean
#'   and impact matrix (including the constant terms of the density). The varying impact matrix
#'   is calculated within the function from the impact matrices of the regimes and transition weights.
#'
#' @inheritParams ind_Student_densities_Cpp
#' @param all_nu a numeric vector of length \eqn{d}, containing the degrees of freedom parameters for each component.
#' @param all_lambda a numeric vector of length \eqn{d}, containing the skewness parameters for each component.
#' @details Returns \code{minval} if the impact matrix \eqn{B_t} is not invertible for some t up to the numerical tolerance
#'  \code{posdef_tol}.
#' @return A numeric vector of length \eqn{T}, where each element represents the computed density component for
#'  the corresponding observation.
#' @keywords internal
ind_skewed_t_densities_Cpp <- function(obs, means, impact_matrices, alpha_mt, all_nu, all_lambda, minval, posdef_tol) {
    .Call('_sstvars_ind_skewed_t_densities_Cpp', PACKAGE = 'sstvars', obs, means, impact_matrices, alpha_mt, all_nu, all_lambda, minval, posdef_tol)
}

