% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/twostep.R
\name{twostep}
\alias{twostep}
\title{Two-Step Estimation of the Classic Heckman Model}
\usage{
twostep(selection, outcome, data = sys.frame(sys.parent()))
}
\arguments{
\item{selection}{A formula for the selection equation.}

\item{outcome}{A formula for the outcome equation.}

\item{data}{A data frame containing the variables.}
}
\value{
A numeric vector containing:
\itemize{
  \item Estimated coefficients of the selection equation (Probit model),
  \item Estimated coefficients of the outcome equation (excluding IMR),
  \item Estimated standard deviation of the outcome errors (\code{phi}),
  \item Estimated correlation between the error terms (\code{cor}).
}
}
\description{
Estimates the parameters of the classical Heckman sample selection model
using the two-step procedure.
}
\details{
The two-step method first estimates a Probit model for the selection equation,
then fits an outcome equation that includes the Inverse Mills Ratio (IMR)
as an additional regressor to correct for sample selection bias.
}
\examples{
data(MEPS2001)
attach(MEPS2001)
selectEq <- dambexp ~ age + female + educ + blhisp + totchr + ins + income
outcomeEq <- lnambx ~ age + female + educ + blhisp + totchr + ins
twostep(selectEq, outcomeEq, data = MEPS2001)

}
\references{
\insertAllCited{}
For details, see \insertCite{heckman1979sample;textual}{ssmodels}.
}
