% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/npmle.R
\name{uni.npmle}
\alias{uni.npmle}
\title{Univariate NPMLE}
\usage{
uni.npmle(D, maxit = 200, tol = 1e-04, verbose = FALSE)
}
\arguments{
\item{D}{p x d matrix of conditional density values, where the \eqn{ij}th entry is \eqn{f(X_i;u_j)}}

\item{maxit}{maximum number of EM iterations}

\item{tol}{error tolerance}

\item{verbose}{TRUE to print the error attained by each EM iteration}
}
\value{
\item{g}{d x 1 vector of probability masses at each grid point}
}
\description{
General nonparametric maximum likelihood estimation for a univariate mixing distribution, implemented using EM. Assumes that the observed data are \eqn{X_i} with marginal likelihood
\deqn{\int f(X_i;u)dG(u),}
where \eqn{G} is the mixing distribution to be estimated. Suppose there are p observations and \eqn{G} is to be estimated on a grid of d points.
}
\examples{
## generate parameters from mixing distribution
p <- 1000;
set.seed(1); theta <- rnorm(p);
## generate observed variables
X <- rnorm(p,theta,1);
## set grid points
d <- 25;
Theta <- seq(min(X),max(X),length=d);
## calculate D matrix
D <- outer(X,Theta,function(x,y){
  dnorm(x,y,1);
});
## fit npmle
g <- uni.npmle(D);
plot(Theta,g/sum(g*(Theta[2]-Theta[1])),type="l");
lines(Theta,dnorm(Theta),col="red");

}
