% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/main.R
\name{MRWR}
\alias{MRWR}
\title{A global propagation algorithm, random walk with restart (RWR), to predict probable influence of nodes in the network by seed nodes.}
\usage{
MRWR(
  net_AdjMatrNorm,
  Seeds,
  net_data,
  mut_gene,
  r = 0.7,
  BC_Num = length(V(net_data)$name),
  cut_point = 0
)
}
\arguments{
\item{net_AdjMatrNorm}{Row normalized network adjacency matrix.}

\item{Seeds}{A vector containing the gene symbols of the seed nodes.}

\item{net_data}{A list of the PPI network information,including nodes and edges .}

\item{mut_gene}{A vector containing the gene symbols of the mutated genes in a sample.}

\item{r}{A numeric value between 0 and 1. r is a certain probability of continuing the random walk or restarting from the restart set. Default to 0.7.}

\item{BC_Num}{Number of background genes required to calculate seed node weight.}

\item{cut_point}{The threshold of indicator function .}
}
\value{
An matrix of global weight, where the row names are genes in the network and the column names are samples.
}
\description{
The function `MRWR` is used to predict probable influence of nodes in the network by seed nodes.
}
\examples{
#load the data
net_path <- system.file("extdata","ppi_network.Rdata",package = "ssMutPA")
load(net_path)
net_AdjMatr<-as.matrix(igraph::get.adjacency(ppi_network))
net_AdjMatrNorm <- t(t(net_AdjMatr)/(Matrix::colSums(net_AdjMatr, na.rm = FALSE, dims = 1)))
data(mut_status)
mut_gene<-intersect(names(mut_status[,1])[which(mut_status[,1]!=0)],igraph::V(ppi_network)$name)
seed<-intersect(names(mut_status[,1])[which(mut_status[,1]!=0)],igraph::V(ppi_network)$name)
#perform the function `MRWR`.
\donttest{RWR_res<-MRWR(net_AdjMatrNorm,Seeds=seed,net_data=ppi_network,mut_gene,BC_Num = 12436)}
}
