% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ss3sim_base.r
\name{ss3sim_base}
\alias{ss3sim_base}
\title{Base wrapper function to run an ss3sim simulation}
\usage{
ss3sim_base(iterations, scenarios, f_params, index_params, lcomp_params,
  agecomp_params, calcomp_params = NULL, wtatage_params = NULL,
  mlacomp_params = NULL, em_binning_params = NULL, estim_params = NULL,
  tv_params = NULL, om_dir, em_dir, retro_params = NULL,
  data_params = NULL, call_change_data = TRUE, user_recdevs = NULL,
  user_recdevs_warn = TRUE, bias_adjust = FALSE, bias_nsim = 5,
  bias_already_run = FALSE, hess_always = FALSE, print_logfile = TRUE,
  sleep = 0, conv_crit = 0.2, seed = 21, keep_compreport = TRUE, ...)
}
\arguments{
\item{iterations}{Which iterations to run. A numeric vector.}

\item{scenarios}{Which scenarios to run.}

\item{f_params}{A named list containing arguments for \code{\link{change_f}}.
A mandatory case.}

\item{index_params}{A named list containing arguments for
\code{\link{sample_index}}. A mandatory case.}

\item{lcomp_params}{A named list containing arguments for
\code{\link{sample_lcomp}}. A mandatory case.}

\item{agecomp_params}{A named list containing arguments for
\code{\link{sample_agecomp}}. A mandatory case.}

\item{calcomp_params}{A named list containing arguments for
\code{\link{sample_calcomp}}, for conditional age-at-length data.}

\item{wtatage_params}{A named list containing arguments for
\code{\link{sample_wtatage}}, for empirical weight-at-age data.}

\item{mlacomp_params}{A named list containing arguments for
\code{\link{sample_mlacomp}}, for mean length-at-age data.}

\item{em_binning_params}{A named list containing arguments for
\code{\link{change_em_binning}}.}

\item{estim_params}{A named list containing arguments for
\code{\link{change_e}}.}

\item{tv_params}{A named list containing arguments for
\code{\link{change_tv}} (time-varying).}

\item{om_dir}{The directory with the operating model you want to copy and use
for the specified simulations.}

\item{em_dir}{The directory with the estimation model you want to copy and
use for the specified simulations.}

\item{retro_params}{A named list containing arguments for
\code{\link{change_retro}}.}

\item{data_params}{A named list containing arguments for
\code{\link{change_data}}.}

\item{call_change_data}{A boolean of whether to call
\code{\link{change_data}} and modify the OM at each iteration. Defaults to
\code{TRUE}. See the vignette for further information on why you might
choose to turn this off.}

\item{user_recdevs}{An optional matrix of recruitment deviations to replace
the recruitment deviations built into the package. The columns represent
run iterations and the rows represent years. \code{user_recdevs} can be a
matrix of 0s for deterministic model checking. For traditional stochastic
simulations these would be independent and normally distributed deviations
with a standard deviation equal to the desired sigma R. Note that these
recruitment deviations will be used verbatim (after exponentiation).
\code{user_recdevs} will *not* be multiplied by sigma R and they will *not*
be log-normal bias corrected. If \code{user_recdevs} are specified as
anything besides \code{NULL} the package will issue a warning about this.
Biased recruitment deviations can lead to biased model results.}

\item{user_recdevs_warn}{A logical argument allowing users to turn the
warning regarding biased recruitment deviations off when \code{user_recdevs}
are specified.}

\item{bias_adjust}{Run bias adjustment first? See \code{\link{run_bias_ss3}}.}

\item{bias_nsim}{If bias adjustment is run, how many simulations should the
bias adjustment factor be estimated from? It will take the mean of the
adjustment factors across these runs.}

\item{bias_already_run}{If you've already run the bias runs for a scenario
(the bias folders and \code{.dat} files already exist) then you can set
this to \code{TRUE} to avoid re-running the bias adjustment routine.}

\item{hess_always}{If \code{TRUE} then the Hessian will always be calculated.
If \code{FALSE} then the Hessian will only be calculated for
bias-adjustment runs thereby saving time.}

\item{print_logfile}{Logical. Print a log file?}

\item{sleep}{A time interval (in seconds) to pause on each iteration. Useful
if you want to reduce average CPU time -- perhaps because you're working on
a shared server.}

\item{conv_crit}{The maximum percentage of bias iterations that can produce a
non-invertible Hessian before a warning will be produced. If this
percentage is exceeded then a file \code{WARNINGS.txt} will be produced.
Currently, the simulations will continue to run.}

\item{seed}{The seed value to pass to \code{\link{get_recdevs}} when
generating recruitment deviations. The generated recruitment deviations
depend on the iteration value, but also on the value of \code{seed}. A
given combination of iteration, number of years, and \code{seed} value will
result in the same recruitment deviations.}

\item{keep_compreport}{Logical: should the SS3 file \code{CompReport.sso} be
kept or deleted? \code{CompReport.sso} is often rather large and so
deleting it can save space but the file is needed for some of the \pkg{r4ss}
plots among other purposes.}

\item{...}{Anything extra to pass to \code{\link{run_ss3model}}. For
example, you may want to pass additional options to \code{SS3} through
the argument \code{admb_options}. Anything that doesn't match a named
argument in \code{\link{run_ss3model}} will be passed to the
\code{\link{system}} call that runs \code{SS3}.  Also, see the argument
\code{ss_mode} to choose between safe or optimized SS3 executables
(default is safe mode).}
}
\value{
The output will appear in whatever your current \R working directory
is. There will be folders named after your scenarios. They will
look like this:
\itemize{
\item \code{D0-F0-cod/bias/1/om}
\item \code{D0-F0-cod/bias/1/em}
\item \code{D0-F0-cod/bias/2/om}
\item ...
\item \code{D0-F0-cod/1/om}
\item \code{D0-F0-cod/1/em}
\item \code{D0-F0-cod/2/om}
\item ...
}
}
\description{
This function is a wrapper function that can call \code{\link{run_ss3model}}
for the operating model, sample the output (add recruitment deviations,
survey the data, etc.), and run the estimation model. \code{ss3sim_base} is
the main internal function for \pkg{ss3sim}. It is intended to be used
through \code{\link{run_ss3sim}}, but can also be used directly.
}
\details{
This function is written to be flexible. You can specify the fishing
mortality, survey index, length composition, age composition, and
time-varying parameters in the function call as list objects (see the
example below). For a generic higher-level function, see
\code{\link{run_ss3sim}}.
}
\examples{
\dontrun{
# Create a temporary folder for the output and set the working directory:
temp_path <- file.path(tempdir(), "ss3sim-base-example")
dir.create(temp_path, showWarnings = FALSE)
wd <- getwd()
setwd(temp_path)

# Find the data in the ss3sim package:
d <- system.file("extdata", package = "ss3sim")
om <- paste0(d, "/models/cod-om")
em <- paste0(d, "/models/cod-em")
case_folder <- paste0(d, "/eg-cases")

# Pull in file paths from the package example data:
d <- system.file("extdata", package = "ss3sim")
om_dir <- paste0(d, "/models/cod-om")
em_dir <- paste0(d, "/models/cod-em")
a <- get_caseargs(folder = paste0(d, "/eg-cases"), scenario =
"F0-D0-M0-E0-cod")

ss3sim_base(iterations = 1, scenarios = "M0-F0-D0-E0-cod",
  f_params = a$F, index_params = a$index, lcomp_params = a$lcomp,
  agecomp_params = a$agecomp, tv_params = a$tv_params, estim_params = a$E,
  om_dir = om_dir, em_dir = em_dir)
unlink("M0-F0-D0-E0-cod", recursive = TRUE) # clean up

# Or, create the argument lists directly in R and skip the case file setup:

F0 <- list(years = 1913:2012, years_alter = 1913:2012, fvals = c(rep(0,
  25), rep(0.114, 75)))

index1 <- list(fleets = 2, years = list(seq(1974, 2012, by = 2)), sds_obs =
  list(0.1))

lcomp1 <- list(fleets = c(1, 2), Nsamp = list(100, 100), years =
  list(1938:2012, seq(1974, 2012, by = 2)), lengthbin_vector = NULL, cpar =
  c(1, 1))

agecomp1 <- list(fleets = c(1, 2), Nsamp = list(100, 100), years =
  list(1938:2012, seq(1974, 2012, by = 2)), agebin_vector = NULL, cpar =
  c(1, 1))

E0 <- list(natM_type = "1Parm", natM_n_breakpoints = NULL, natM_lorenzen =
  NULL, natM_val = c(NA,-1), par_name = "LnQ_base_3_CPUE", par_int = NA,
  par_phase = -1, forecast_num = 0)

M0 <- list(NatM_p_1_Fem_GP_1 = rep(0, 100))

ss3sim_base(iterations = 1, scenarios = "D1-E0-F0-M0-cod",
  f_params = F0, index_params = index1, lcomp_params = lcomp1,
  agecomp_params = agecomp1, estim_params = E0, tv_params = M0,
  om_dir = om, em_dir = em)

unlink("D1-E0-F0-M0-cod", recursive = TRUE) # clean up

setwd(wd)
}
}
\author{
Sean Anderson with contributions from many others as listed in
  the DESCRIPTION file.
}
\seealso{
\code{\link{run_ss3sim}}
}

