% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sreg_poisson.R
\name{sreg_poisson}
\alias{sreg_poisson}
\title{Semiparametric Model-Assisted Estimation under a Poisson Sampling Design}
\usage{
sreg_poisson(location_formula, scale_formula, data, pis)
}
\arguments{
\item{location_formula}{a symbolic description of the systematic component of the location model to be fitted.}

\item{scale_formula}{a symbolic description of the systematic component of the scale model to be fitted.}

\item{data}{a data frame, list containing the variables in the model.}

\item{pis}{numeric vector, first order inclusion probabilities. Default value 0.1 for each element.}
}
\value{
\code{sampling_design} is the name of the sampling design used in the estimation process.

\code{N} is the population size.

\code{n} is the random sample size used in the estimation process.

\code{first_order_probabilities} vector of the first order probabilities used in the estimation process.

\code{sample} is the random sample used in the estimation process.

\code{total_y_sreg} is the SREG estimate of the total parameter of the finite population.
}
\description{
\code{sreg_poisson} is used to estimate the total parameter of a finite population generated from a semi-parametric generalized gamma population under a Poisson sampling design.
}
\examples{
library(survey)
library(dplyr)
data(api)
attach(apipop)
Apipop <- filter(apipop,full!= 'NA')
Apipop <- filter(Apipop, stype == 'H')
Apipop <- select(Apipop,c(api00,grad.sch,full))
sreg_poisson(api00 ~  pb(grad.sch), scale_formula = ~ full - 1, data= Apipop)
sum(Apipop$api00)
}
\references{
Cardozo C.A, Alonso C. (2021) Semi-parametric model assisted estimation in finite populations. In preparation.

Sarndal C.E.,  Swensson B., and Wretman J. (2003). Model Assisted Survey Sampling. Springer.
}
\author{
Carlos Alberto Cardozo Delgado <cardozorpackages@gmail.com>
}
