% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/qts-prcomp.R
\name{predict.prcomp_qts}
\alias{predict.prcomp_qts}
\title{Predict QTS from PCA decomposition}
\usage{
\method{predict}{prcomp_qts}(object, newdata, ...)
}
\arguments{
\item{object}{An object of class \code{prcomp_qts} as produced by the
\code{\link[=prcomp.qts_sample]{prcomp.qts_sample()}} method.}

\item{newdata}{An object of class \code{\link{qts}} or \code{\link{qts_sample}} specifying a QTS
or a sample of QTS. The QTS should be evaluated on the same grid as the one
used to fit the PCA model. If the evaluation grids map the same domain but
with different sampling frequenciesa, the QTS will be linearly interpolated
(in the Lie algebra) to the common grid used to fit the PCA model.}

\item{...}{Additional arguments. Not used here.}
}
\value{
An object of class \code{\link{qts_sample}} containing the predicted QTS.
}
\description{
This function predicts the QTS of a new sample from the PCA decomposition of
a previous sample.
}
\examples{
# Fit PCA model
pr <- prcomp(vespa64$igp, M = 5)

# Predict QTS
new_qts <- predict(pr)
}
