% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/qts-kmeans.R
\name{kmeans}
\alias{kmeans}
\alias{kmeans.default}
\alias{kmeans.qts_sample}
\title{QTS K-Means Alignment Algorithm}
\usage{
kmeans(x, k, iter_max = 10, nstart = 1, ...)

\method{kmeans}{default}(
  x,
  k,
  iter_max = 10,
  nstart = 1,
  algorithm = c("Hartigan-Wong", "Lloyd", "Forgy", "MacQueen"),
  trace = FALSE,
  ...
)

\method{kmeans}{qts_sample}(
  x,
  k = 1,
  iter_max = 10,
  nstart = 1,
  centroid = "mean",
  dissimilarity = "l2",
  warping = "affine",
  ...
)
}
\arguments{
\item{x}{Either a numeric matrix of data, or an object that can be coerced to
such a matrix (such as a numeric vector or a data frame with all numeric
columns) or an object of class \link{qts_sample}.}

\item{k}{An integer value specifying the number of clusters to be look for.}

\item{iter_max}{An integer value specifying the maximum number of iterations
for terminating the k-mean algorithm. Defaults to \code{10L}.}

\item{nstart}{An integer value specifying the number of random restarts of
the algorithm. The higher \code{nstart}, the more robust the result. Defaults to
\code{1L}.}

\item{...}{not used.}

\item{algorithm}{character: may be abbreviated.  Note that
    \code{"Lloyd"} and \code{"Forgy"} are alternative names for one
    algorithm.}

\item{trace}{logical or integer number, currently only used in the
    default method (\code{"Hartigan-Wong"}): if positive (or true),
    tracing information on the progress of the algorithm is
    produced.  Higher values may produce more tracing information.}

\item{centroid}{A string specifying which type of centroid should be used
when applying kmeans on a QTS sample. Choices are \code{mean} and \code{medoid}.
Defaults to \code{mean}.}

\item{dissimilarity}{A string specifying which type of dissimilarity should
be used when applying kmeans on a QTS sample. Choices are \code{l2} and
\code{pearson}. Defaults to \code{l2}.}

\item{warping}{A string specifying which class of warping functions should be
used when applying kmeans on a QTS sample. Choices are \code{none}, \code{shift},
\code{dilation} and \code{affine}. Defaults to \code{affine}.}
}
\value{
An object of class \code{\link[stats:kmeans]{stats::kmeans}} if the input \code{x} is NOT of class
\code{\link{qts_sample}}. Otherwise, an object of class \code{kma_qts} which is
effectively a list with three components:
\itemize{
\item \code{qts_aligned}: An object of class \link{qts_sample} storing the sample of
aligned QTS;
\item \code{qts_centers}: A list of objects of class \link{qts} representing the centers of
the clusters;
\item \code{best_kma_result}: An object of class \link[fdacluster:kma]{fdacluster::kma} storing the results
of the best k-mean alignment result among all initialization that were tried.
}
}
\description{
This function massages the input quaternion time series to feed them into the
k-means alignment algorithm for jointly clustering and aligning the input
QTS.
}
\examples{
res_kma <- kmeans(vespa64$igp, k = 2)
}
