% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_player_rankings_history.R
\name{get_player_rankings_history}
\alias{get_player_rankings_history}
\title{Get a player's PSA ranking history from SquashInfo}
\usage{
get_player_rankings_history(player = NULL, rank = NULL, category = NULL)
}
\arguments{
\item{player}{character string of player name(s).}

\item{rank}{integer indicating the rank of the PSA player(s) to return.}

\item{category}{character string indicating the competition category. Must be one of "both", "mens", or "womens".}
}
\value{
Tibble containing the year, month, exact date, rank, player name and player's current rank.
}
\description{
Given a player name or rank, and a competition category, \code{get_player_rankings_history()} returns a tidy version of the PSA rankings history table for that player(s).
}
\note{
This function only returns PSA ranking histories for players currently ranked in PSA Men's and Women's singles competitions.
}
\examples{

## Get the rankings history for the top two men's singles players
\donttest{top_two <- get_player_rankings_history(rank = 1:2, category = "mens")}

## Get the rankings history for the top three women's singles players
\donttest{top_three <- get_player_rankings_history(rank = 1:3, category = "womens")}

}
\references{
\url{http://www.squashinfo.com/rankings/men} \cr
    \url{http://www.squashinfo.com/rankings/women}
}
