% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sp_plot.R
\name{sp_plot}
\alias{sp_plot}
\alias{sp_plot.default}
\alias{sp_plot.spdesign}
\title{Plot sampling frames, design sites, and analysis data.}
\usage{
sp_plot(object, ...)

\method{sp_plot}{default}(
  object,
  formula = ~1,
  xcoord,
  ycoord,
  crs,
  var_args = NULL,
  varlevel_args = NULL,
  geom = FALSE,
  onlyshow = NULL,
  fix_bbox = TRUE,
  ...
)

\method{sp_plot}{spdesign}(
  object,
  sframe = NULL,
  formula = ~siteuse,
  siteuse = NULL,
  var_args = NULL,
  varlevel_args = NULL,
  geom = FALSE,
  onlyshow = NULL,
  fix_bbox = TRUE,
  ...
)
}
\arguments{
\item{object}{An object to plot. When plotting sampling frames or analysis data,
a data frame or \code{sf} object. When plotting design sites, an object created by \code{grts()} or
\code{irs()} (which has class \code{spdesign}).}

\item{...}{Additional arguments to pass to \code{plot.sf()}.}

\item{formula}{A formula. One-sided formulas are used to summarize the
distribution of numeric or categorical variables. For one-sided formulas,
variable names are placed to the right of \code{~} (a right-hand side variable).
Two sided formulas are
used to summarize the distribution of a left-hand side variable
for each level of each right-hand side categorical variable in the formula.
Note that only for two-sided formulas are numeric right-hand side variables
coerced to a categorical variables. If an intercept
is included as a right-hand side variable (whether the formula is one-sided or
two-sided), the total will also be summarized. When plotting sampling frames
or analysis data, the default formula is \code{~ 1}. When plotting design sites,
\code{siteuse} should be used in the formula, and the default formula is
\code{~ siteuse}.}

\item{xcoord}{Name of the x-coordinate (east-west) in \code{object} (only required if
\code{object} is not an \code{sf} object).}

\item{ycoord}{Name of y (north-south)-coordinate in \code{object} (only required if
\code{object} is not an \code{sf} object).}

\item{crs}{Projection code for \code{xcoord} and \code{ycoord} (only
required if \code{object} is not an \code{sf} object).}

\item{var_args}{A named list. The name of each list element corresponds to a
right-hand side variable in \code{formula}. Values in the list are composed of
graphical arguments that are to be passed to \strong{every} level of the
variable. To see all graphical arguments available, run \code{?plot.sf}.}

\item{varlevel_args}{A named list. The name of each list element corresponds to a
right-hand side variable in \code{formula}. The first element in this list
should be \code{"levels"} and contain all levels of the particular right-hand side variable. Subsequent
names correspond to graphical arguments that are to be passed to
the specified levels (in order) of the right-hand side variable. Values for each
graphical argument must be specified for each level of the right-hand side variable,
but applicable sf defaults will be matched by inputting the value \code{NA}.
To see all graphical arguments available, run \code{?plot.sf}}

\item{geom}{Should separate geometries for each level of the right-hand
side \code{formula} variables be plotted? Defaults to \code{FALSE}.}

\item{onlyshow}{A string indicating the single level of the single right-hand side
variable for which a summary is requested. This argument is only used when
a single right-hand side variable is provided.}

\item{fix_bbox}{Should the geometry bounding box be fixed across plots?
Defaults to \code{TRUE}. If \code{TRUE}, the bounding box for each plot will be
unique to its coordinates.}

\item{sframe}{The sampling frame (an \code{sf} object) to plot alongside design
sites. This argument is only used when \code{object} corresponds to the design sites.}

\item{siteuse}{A character vector of site types to include when plotting design sites.
It can only take on values \code{"sframe"} (sampling frame),
\code{"Legacy"} (for legacy sites), \code{"Base"} (for base sites),
\code{"Over"} (for \code{n_over} replacement sites), and \code{"Near"}
(for \code{n_near} replacement sites). The order of sites represents the
layering in the plot (e.g. \code{siteuse = c("Base", "Legacy")} will plot
legacy sites on top of base sites. Defaults to all non-\code{NULL} elements
in \code{x} and \code{y} with plot order \code{"sframe"}, \code{"Legacy"},
\code{"Base"}, \code{"Over"}, \code{"Near"}.}
}
\description{
This function plots sampling frames, design sites, and analysis data.
If the left-hand side of the formula is empty, plots
are of the distributions of the right-hand side variables. If the left-hand side
of the variable contains a variable, plots are of the left-hand size variable
for each level of each right-hand side variable.
This function is largely built on \code{plot.sf()}, and all spsurvey plotting
methods can supply additional arguments to \code{plot.sf()}. For more information on
plotting in \code{sf}, run \code{?sf::plot.sf()}.
}
\examples{
data("NE_Lakes")
sp_plot(NE_Lakes, formula = ~ELEV_CAT)
sample <- grts(NE_Lakes, 30)
sp_plot(sample, NE_Lakes)
data("NLA_PNW")
sp_plot(NLA_PNW, formula = ~BMMI)
}
\author{
Michael Dumelle \email{Dumelle.Michael@epa.gov}
}
