% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dsgnsum.R
\name{dsgnsum}
\alias{dsgnsum}
\title{Summary of a Survey Design}
\usage{
dsgnsum(spsample, auxvar = NULL)
}
\arguments{
\item{spsample}{An object of class SpatialDesign produced by either the
grts or irs functions that contains survey design information and
additional attribute (auxiliary) variables.}

\item{auxvar}{Vector containing the names of columns in the data slot of
the}
}
\value{
A list containing two components named DesignSum and AuxVarSum.
  DesignSum is a list of contingency tables containing the cross-tabulation
  of number of sites for the following combinations of survey design
  variables:

  \itemize{
    \item multidensity category (mdcaty) and stratum
    \item stratum and panel
    \item mdcaty, panel, and stratum
  }

  AuxVarSum is a list of contingency tables containing the cross-tabulation
  of number of sites for each auxiliary variable and the design variables
  mdcaty, panel, and stratum.

  In addition the output list plus labeling information is printed to the
  console.
}
\description{
This function summarizes the sites selected for a survey design by producing
contingency tables containing the cross-tabluation of number of sites for
survey design variables and, optionally, for auxiliary variables.
}
\section{Other Functions Required}{

  \describe{
    \item{\code{\link{vecprint}}}{takes an input vector and outputs a
      character string with line breaks inserted}
  }
}

\examples{
\dontrun{
design <- list(
  Stratum1=list(panel=c(PanelOne=50), seltype="Equal", over=10),
  Stratum2=list(panel=c(PanelOne=50, PanelTwo=50), seltype="Unequal",
    caty.n=c(CatyOne=25, CatyTwo=25, CatyThree=25, CatyFour=25), over=75))
attframe <- read.dbf("shapefile")
samp <- grts(design=design, DesignID="Test.Site", type.frame="area",
  src.frame="shapefile", in.shape="shapefile", att.frame=attframe,
  stratum="stratum", mdcaty="mdcaty", shapefile=TRUE,
  shapefilename="sample")
dsgnsum(samp, auxvar=c("ecoregion", "state"))
}

}
\author{
Tom Kincaid \email{Kincaid.Tom@epa.gov}
}
\keyword{survey}
