% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/font_awesome_animate.R
\name{animateAppend}
\alias{animateAppend}
\alias{animateAppendNested}
\title{Append animation to a Shiny element}
\usage{
animateAppend(element, animation, speed = NULL, hover = FALSE)

animateAppendNested(
  element,
  animation,
  speed = NULL,
  hover = FALSE,
  display = "inline-block",
  ...
)
}
\arguments{
\item{element}{the shiny element to append, must have "shiny.tag" class for
\code{animateAppend} and can be either "shiny.tag" or "shiny.tag.list" for \code{animateAppendNested}.}

\item{animation}{what kind of animation you want, one of "wrench", "ring",
"horizontal", "horizontal-reverse", "vertical", "flash", "bounce", "bounce-reverse",
"spin", "spin-reverse", "float", "pulse", "shake", "tada", "passing", "passing-reverse",
"burst", "falling", "falling-reverse", "rising"s
See our online demo for details.}

\item{speed}{string, one of "fast", "slow"}

\item{hover}{bool, trigger animation on hover?}

\item{display}{string, CSS display method for the out-most wrapper, one of the v
alid css display method, like "block", "inline", "flex", default is "inline-block".}

\item{...}{other attributes add to the wrapper, for \code{animateAppendNested} only}
}
\value{
returns a Shiny element
}
\description{
Append animation to a Shiny element
}
\details{
\subsection{\code{animateAppend}}{

Append the animation directly to the element you provide, but can only apply
one type of animation
}

\subsection{\code{animateAppendNested}}{

Append multiple animations to the element you provide by creating a wrapper
around the element. Animations are applied on the wrappers. This may cause some
unknown issues, especially on the display property. Try change the display may
fix the issues. It is \strong{safer} to use \code{animateAppend}.

Read more about CSS display: https://www.w3schools.com/cssref/pr_class_display.asp
}
}
\examples{
if (interactive()){
  library(shiny)

  ui <- fluidPage(
    icon("home") \%>\%
      animateAppend("ring"),
    h2("Append animation", class = "text-primary") \%>\%
      animateAppend("pulse"),
    br(),
    h2("Nested animations", class = "text-primary") \%>\%
      animateAppendNested("ring") \%>\%
      animateAppendNested("pulse") \%>\%
      animateAppendNested("passing"),
    tags$span("Other things"),
    h2("Nested animations display changed", class = "text-primary") \%>\%
      animateAppendNested("ring") \%>\%
      animateAppendNested("pulse", display = "block", style = "width: 30\%"),
    tags$span("Other things")
  )

  server <- function(input, output, session) {

  }

  shinyApp(ui, server)
}
}
