% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/local_clustering.R
\name{local_clustering}
\alias{local_clustering}
\title{Clustering hot spots spatially}
\usage{
local_clustering(lon, lat, adjDist)
}
\arguments{
\item{lon}{Numeric. A vector of longitude values.}

\item{lat}{Numeric. A vector of latitude values.}

\item{adjDist}{Numeric (>0). Distance tolerance. Unit is metre.}
}
\value{
Integer. A vector of membership labels.
}
\description{
This function clusters hot spots spatially.
}
\details{
For more details about the clustering algorithm and the argument \code{adjDist},
please check the documentation of \code{\link[=hotspot_cluster]{hotspot_cluster()}}.
This function performs the \strong{step 2} of the clustering algorithm. It
clusters hot spots in a given interval.
}
\examples{

# Define lon and lat for 10 observations
lon <- c(141.1, 141.14, 141.12, 141.14, 141.16, 141.12, 141.14,
          141.16, 141.12, 141.14)
lat <- c(-37.10, -37.10, -37.12, -37.12, -37.12, -37.14, -37.14,
         -37.14, -37.16, -37.16)

# Cluster 10 hot spots with different values of adjDist
local_clustering(lon, lat, 2000)
local_clustering(lon, lat, 3000)
local_clustering(lon, lat, 4000)

}
