% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_playlist_tracks.R
\name{get_playlist_tracks}
\alias{get_playlist_tracks}
\title{Get tracks from one or more playlists}
\usage{
get_playlist_tracks(playlists, access_token = get_spotify_access_token())
}
\arguments{
\item{playlists}{Dataframe containing the columns `playlist_num_tracks`, `playlist_tracks_url`, `playlist_name`, and `playlist_img`, corresponding to Spotify playlists. Can be output from spotifyr::get_user_playlists()}

\item{access_token}{Spotify Web API token. Defaults to spotifyr::get_spotify_access_token()}
}
\description{
This function returns tracks from a dataframe of playlists on Spotify
}
\examples{
\dontrun{
playlists <- get_user_playlists('barackobama')
playlist_tracks <- get_playlist_tracks(playlists)
}
}
\keyword{album}
\keyword{tracks}
