% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/mapgist.r
\name{mapgist}
\alias{mapgist}
\title{Make an interactive map to view in the browser as a Github gist}
\usage{
mapgist(data, description = "", file = "gistmap", dir = NULL,
  public = TRUE, browse = TRUE, ...)
}
\arguments{
\item{data}{A data.frame, with any number of columns, but with at least the
following: name (the taxonomic name), latitude (in dec. deg.), longitude
(in dec. deg.)}

\item{description}{Description for the Github gist, or leave to default (=no description)}

\item{file}{File name (without file extension) for your geojson file. Default is 'gistmap'.}

\item{dir}{Directory for storing file and reading it back in to create gist.
If none is given, this function gets your working directory and uses that.}

\item{public}{(logical) Whether gist is public (default: TRUE)}

\item{browse}{If TRUE (default) the map opens in your default browser.}

\item{...}{Further arguments passed on to \code{spocc_stylegeojson}}
}
\description{
Make an interactive map to view in the browser as a Github gist
}
\details{
See \code{\link[gistr]{gist_auth}} for help on authentication
}
\examples{
\dontrun{
spp <- c('Danaus plexippus','Accipiter striatus','Pinus contorta')
dat <- occ(spp, from=c('gbif','ecoengine'), limit=30, gbifopts=list(hasCoordinate=TRUE))
dat <- fixnames(dat, "query")

# Define colors
mapgist(data=dat, color=c('#976AAE','#6B944D','#BD5945'))
mapgist(data=dat$gbif, color=c('#976AAE','#6B944D','#BD5945'))
mapgist(data=dat$ecoengine, color=c('#976AAE','#6B944D','#BD5945'))

# Define colors and marker size
mapgist(data=dat, color=c('#976AAE','#6B944D','#BD5945'), size=c('small','medium','large'))

# Define symbols
mapgist(data=dat, symbol=c('park','zoo','garden'))
}
}

