% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rfidwpred.R
\name{rfidwpred}
\alias{rfidwpred}
\title{Generate spatial predictions using the hybrid method of random forest and inverse distance weighting (RFIDW)}
\usage{
rfidwpred(longlat, trainx, trainy, longlatpredx, predx, mtry = function(p)
  max(1, floor(sqrt(p))), ntree = 500, idp = 2, nmax = 12, ...)
}
\arguments{
\item{longlat}{a dataframe contains longitude and latitude of validation
samples.}

\item{trainx}{a dataframe or matrix contains columns of predictive variables.}

\item{trainy}{a vector of response, must have length equal to the number of
rows in trainx.}

\item{longlatpredx}{a dataframe contains longitude and latitude of point locations
(i.e., the centres of grids) to be predicted.}

\item{predx}{a dataframe or matrix contains columns of predictive variables for
the grids to be predicted.}

\item{mtry}{a function of number of remaining predictor variables to use as
the mtry parameter in the randomForest call.}

\item{ntree}{number of trees to grow. This should not be set to too small a
number, to ensure that every input row gets predicted at least a few times.
By default, 500 is used.}

\item{idp}{numeric; specify the inverse distance weighting power.}

\item{nmax}{for local predicting: the number of nearest observations that
should be used for a prediction or simulation, where nearest is
defined in terms of the space of the spatial locations. By default, 12
observations are used.}

\item{...}{other arguments passed on to randomForest or gstat.}
}
\value{
A dataframe of longitude, latitude and predictions.
}
\description{
This function is to make spatial predictions using the hybrid
method of random forest and inverse distance weighting (RFIDW).
}
\examples{
\dontrun{
data(petrel)
data(petrel.grid)
rfidwpred1 <- rfidwpred(petrel[, c(1,2)], petrel[, c(1,2, 6:9)], petrel[, 3],
petrel.grid[, c(1,2)], petrel.grid, ntree = 500, idp = 2, nmax = 12)
names(rfidwpred1)
}

}
\references{
Liaw, A. and M. Wiener (2002). Classification and Regression by
randomForest. R News 2(3), 18-22.
}
\author{
Jin Li
}
