% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{splot.bench}
\alias{splot.bench}
\title{splot benchmarker}
\usage{
splot.bench(..., runs = 20, runsize = 200, cleanup = FALSE,
  print.names = FALSE, options = list())
}
\arguments{
\item{...}{accepts any number of expressions to be timed. See examples.}

\item{runs}{the number of overall iterations. Increase to stabilize estimates.}

\item{runsize}{the number of times each expression is evaluated within each run. Increase to
differentiate estimates (particularly for very fast operations).}

\item{cleanup}{logical; if \code{TRUE}, garbage collection will be performed before each run.
Garbage collection greatly increases run time, but may result in more stable timings.}

\item{print.names}{logical; if \code{FALSE}, the entered expressions will be included in the plot
as legend names. Otherwise, (and if the number of expressions is over 5 or the length of any
expression is over 50 characters) expressions are replaced with numbers corresponding to their
entered position.}

\item{options}{a list of options to pass on to splot.}
}
\description{
Time one or more expressions over several iteration, then plot the distributions of their times.
}
\examples{
# compare a few equivalent ways of looping through a vector
# though you'd probably need to increase the number of runs
# for a consistent determination

splot.bench(
  sapply(1:100,'*',10),
  mapply('*',1:100,10),
  vapply(1:100,'*',0,10),
  unlist(lapply(1:100,'*',10)),
  {a=numeric(100); for(i in 1:100) a[i]=i*10; a}
)
}
