% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/split_aggregations.R
\name{split_ci}
\alias{split_ci}
\title{Calculate nonparametric bias-corrected and accelerated bootstrap confidence
intervals for coefficients averaged across split replications}
\usage{
split_ci(
  ds,
  fn_coef,
  fn_average = function(values) {     mean(values, na.rm = TRUE) },
  replications = 1000,
  ...
)
}
\arguments{
\item{ds}{(data frame) a data frame with columns \code{split},
\code{score_1}, and \code{score_2}}

\item{fn_coef}{(function) a function that calculates a bivariate coefficient.}

\item{fn_average}{(function) a function that calculates an average across coefficients}

\item{replications}{(integer) number of bootstrap replications}

\item{...}{Additional arguments passed to \code{\link[bcaboot]{bcajack}}}
}
\value{
Confidence interval
}
\description{
Calculates nonparametric bias-corrected and accelerated bootstrap confidence intervals
via \code{\link[bcaboot]{bcajack}}. Coefficients are \code{ds} should be a data frame as returned by
\code{\link{by_split}}: Each unique value of the column \code{participant} is considered a independent
sample of the target population. For each unique value of the column \code{split} in
\code{ds}, it selects the corresponding rows in \code{ds}, and passes the
values in the columns \code{score_1} and \code{score_2} as the first and
second argument to \code{fn_coef}. Any row in \code{ds} for which
\code{score_1} or \code{score_2} is NA is pairwise removed before passing the
data to \code{fn_coef}. Any coefficient that is NA is removed before passing
the data to to \code{fn_summary}.
}
\details{
For averaging internal consistency coefficients, see Feldt and Charter (2006). For more 
information about bias-corrected and accelerated bootstrap confidence intervals, see
Efron (1987).
}
\section{References}{


 Efron, B. (1987). Better bootstrap confidence intervals. \emph{Journal of the
 American statistical Association}, 82(397), 171-185.
 \doi{10.1080/01621459.1987.10478410}

 Feldt, L. S., & Charter, R. A. (2006). Averaging internal consistency
 reliability coefficients. \emph{Educational and Psychological Measurement},
 66(2), 215-227.
 \doi{10.1177/0013164404273947}
}

\examples{
# Generate five splits with scores that are correlated 0.00, 0.25, 0.5, 0.75, and 1.00
library(MASS)
ds_splits = data.frame(V1 = numeric(), V2 = numeric(), split = numeric())
for (r in 0:4) {
  vars = mvrnorm(10, mu = c(0, 0), Sigma = matrix(c(10, 3, 3, 2), ncol = 2), empirical = FALSE)
  ds_splits = rbind(ds_splits, cbind(vars, r, 1 : 10))
}
names(ds_splits) = c("score_1", "score_2", "replication", "participant")
# Calculate confidence interval
split_ci(ds_splits, cor)
}
\seealso{
Other split aggregation functions: 
\code{\link{split_coefs}()}
}
\concept{split aggregation functions}
