% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/coefficients.R
\name{angoff_feldt}
\alias{angoff_feldt}
\title{Calculate Angoff-Feldt coefficient}
\usage{
angoff_feldt(x, y)
}
\arguments{
\item{x}{(vector) a numeric vector}

\item{y}{(vector) a numeric vector with compatible dimensions to x}
}
\value{
(numeric) Angoff-Feldt cefficient
}
\description{
Angoff-Feldt reliability coefficient.
Formula obtained from \href{https://link.springer.com/article/10.1007/s11634-015-0198-6}{(Warrens, 2015)}
}
\examples{
# Generate two variables with different means, variances and a correlation of about 0.5
library(MASS)
vars = mvrnorm(30, mu = c(0, 2), Sigma = matrix(c(5, 2, 2, 3), ncol = 2), empirical = TRUE)
# Calculate coefficient
angoff_feldt(vars[,1], vars[,2])
}
\seealso{
Other splithalfr coefficients: 
\code{\link{assmd}()},
\code{\link{flanagan_rulon}()},
\code{\link{sdregi}()},
\code{\link{short_icc}()},
\code{\link{spearman_brown}()}
}
\concept{splithalfr coefficients}
