% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/splinecopulasim.R
\name{spline.copula.simu}
\alias{spline.copula.simu}
\title{Random generation from the B-spline copula using five M-spline basis functions}
\usage{
spline.copula.simu(
  n,
  R = "PE1",
  seed = NULL,
  report_tau = TRUE,
  report_rho = TRUE,
  verbose = FALSE
)
}
\arguments{
\item{n}{Integer. Number of samples to generate.}

\item{R}{A 5×5 non-negative coefficient matrix or a preset name:
\code{"PE1"}, \code{"PE2"}, \code{"PE3"},
\code{"PN1"}, \code{"PN2"}, \code{"PN3"},
\code{"I"},
\code{"NE1"}, \code{"NE2"}, \code{"NE3"},
\code{"NN1"}, \code{"NN2"}, \code{"NN3"}.}

\item{seed}{Optional integer for reproducibility.}

\item{report_tau}{Logical. If TRUE, returns empirical and theoretical Kendall's tau.}

\item{report_rho}{Logical. If TRUE, returns empirical and theoretical Spearman's rho.}

\item{verbose}{Logical. If TRUE, prints correlation results.}
}
\value{
A list containing:
\itemize{
\item \code{U}: simulated U-values;
\item \code{V}: simulated V-values;
\item \code{R}: user-specified R (preset name or matrix).
}
If \code{report_tau = TRUE}, the list also returns:
\itemize{
\item \code{tau_emp}: empirical Kendall's tau;
\item \code{tau_theory}: theoretical Kendall's tau.
}
If \code{report_rho = TRUE}, the list also returns:
\itemize{
\item \code{rho_emp}: empirical Spearman's rho;
\item \code{rho_theory}: theoretical Spearman's rho.
}
}
\description{
\code{spline.copula.simu} generates random samples \eqn{(U, V)} from the B-spline copula
defined by a 5×5 coefficient matrix \code{R}. The simulation uses the inverse transform
method based on the conditional distribution \eqn{V \mid U=u}.
}
\details{
Given \eqn{U \sim \mathrm{Uniform}(0,1)}, the conditional distribution function of
\eqn{V \mid U = u} is
\deqn{F_{V\mid U=u}(v) = M(u)^\top R I(v),}
where \eqn{M(\cdot)} and \eqn{I(\cdot)} are the five M-spline and I-spline basis vectors.
For each \eqn{u}, a draw \eqn{V} is obtained by solving
\eqn{F_{V\mid U=u}(v)=W} for \eqn{v}, where \eqn{W\sim U(0,1)}.

If \code{report_tau = TRUE}, the function also returns:
\itemize{
\item \code{tau_emp}: empirical Kendall's tau of the simulated values;
\item \code{tau_theory}: theoretical Kendall's tau computed using
\code{\link{spline.copula}} with \code{Kendall = TRUE}.
}

If \code{report_rho = TRUE}, the function also returns:
\itemize{
\item \code{rho_emp}: empirical Spearman's rho of the simulated values;
\item \code{rho_theory}: theoretical Spearman's rho computed using
\code{\link{spline.copula}} with \code{Spearman = TRUE}.
}
}
\examples{
set.seed(123)
out <- spline.copula.simu(2000, R = "PE1",
                          report_tau = TRUE,
                          report_rho = TRUE)
out$tau_emp
out$tau_theory
out$rho_emp
out$rho_theory

}
