% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/add_bodymass.R
\name{add_bodymass}
\alias{add_bodymass}
\title{Calculate additional variables related to body mass for cardiopulmonary
exercise testing data}
\usage{
add_bodymass(data, bodymass = NULL)
}
\arguments{
\item{data}{A \code{data.frame} of the class \code{spiro} containing the gas
exchange data. Usually the output of a \code{\link{spiro}} call.}

\item{bodymass}{A numeric value to manually set the participant's body mass.}
}
\value{
A \code{data.frame} of the class \code{spiro} containing the
cardiopulmonary exercise testing data including variables relative to body
mass.
}
\description{
\code{add_bodymass()} amplifies existing spiroergometric data by the
calculation of body mass-related variables.
}
\details{
Based on the participant's body mass relative oxygen uptake (VO2_rel) and
carbon dioxide (VCO2_rel) output are calculated. \code{bodymass} will be
received from the original file's meta data, but can be manually overridden,
e.g. if the value in the meta data is incorrect or rounded.

For running protocols, running economy (RE) is calculated.
}
\examples{
# get example file
file <- spiro_example("zan_gxt")

s <- spiro(file)
out <- add_bodymass(s, bodymass = 65.3)
head(out)
}
