% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/9_data.r
\docType{data}
\name{weather}
\alias{weather}
\alias{weather_na.rm}
\title{Sample dataset of daily weather observations from Canberra airport in Australia.}
\format{
A data frame of 354 observations of 20 variables. One year of
daily observations of weather variables at Canberra airport in Australia
between November 1, 2007 and October 31, 2008.
\itemize{
\item Date, The date of observation (Date class).
\item MinTemp, The minimum temperature in degrees Celsius.
\item MaxTemp, The maximum temperature in degrees Celsius.
\item Rainfall, The amount of rainfall recorded for the day in mm.
\item Evaporation, The "Class A pan evaporation" (mm) in the 24 hours to 9am.
\item WindSpeed3pm, Wind speed (km/hr) averaged over 10 minutes prior to 3pm.
\item Humid9am, Relative humidity (percent) at 9am.
\item Humid3pm, Relative humidity (percent) at 3pm.
\item Pressure9am, Atmospheric pressure (hpa) reduced to mean sea level at 9am.
\item Pressure3pm, Atmospheric pressure (hpa) reduced to mean sea level at 3pm.
\item Cloud9am, Fraction of sky obscured by cloud at 9am. This is measured in "oktas", which are a unit of eighths. It records how many eighths of the sky are obscured by cloud. A 0 measure indicates completely clear sky whilst an 8 indicates that it is completely overcast.
\item Cloud3pm, Fraction of sky obscured by cloud (in "oktas": eighths) at 3pm. See Cloud9am for a description of the values.
\item Temp9am, Temperature (degrees C) at 9am.
\item Temp3pm, Temperature (degrees C) at 3pm.
\item RISK_MM, The amount of rain. A kind of measure of the "risk".
\item RainToday, Factor: "yes" if precipitation (mm) in the 24 hours to 9am exceeds 1mm, otherwise 0.
\item RainTomorrow, Factor: "yes" if it rained the following day, the target variable.
}
Copyright Commonwealth of Australia 2010,
Bureau of Meteorology.
Definitions adapted from http://www.bom.gov.au/climate/dwo/IDCJDW0000.shtml
}
\source{
{Bureau of Meteorology, Commonwealth of Australia} \url{http://www.bom.gov.au/climate/data/}

{rattle, R package. G. Williams, 2020. rattle: Graphical User Interface for Data Science in R} \url{https://CRAN.R-project.org/package=rattle}
}
\usage{
weather_na.rm
}
\description{
One year of daily weather observations collected from the Canberra airport
in Australia was obtained from the Australian Commonwealth Bureau of
Meteorology and processed to create this sample dataset for illustrating
data mining using R and Rattle.
}
\details{
The data has been processed to provide a target variable RainTomorrow
(whether there is rain on the following day - No/Yes) and a risk variable
\code{RISK_MM} (how much rain recorded in millimeters). Various transformations
were performed on the source data. The dataset is quite small and is useful
only for repeatable demonstration of various data science operations.

This is a cleaned subset of \code{rattle::weather}.

Replicating this dataset:

\if{html}{\out{<div class="sourceCode">}}\preformatted{require("rattle")
d <- rattle::weather[, c(1, 3:7, 9, 12:21, 23, 22, 24)]
d <- d[complete.cases(d), ] ## Remove ~12 row-wise incomplete rows
d <- as.data.frame(d)  ## Remove tibble dependency
weather_na.rm <- d
## save(weather_na.rm, file = "./data/weather_na.rm.rda")
}\if{html}{\out{</div>}}
}
\examples{
library(spinifex)
str(weather_na.rm)
dat  <- scale_sd(weather_na.rm[, 2:18])
clas <- weather_na.rm$RainTomorrow

bas <- basis_pca(dat)
mv  <- manip_var_of(bas)
mt  <- manual_tour(bas, mv)

ggt <- ggtour(mt, dat, angle = .2) +
  proto_default(aes_args = list(color = clas, shape = clas))
\donttest{
animate_plotly(ggt)
}
}
\keyword{datasets}
