% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/2_ggproto_visualize.r
\name{proto_frame_cor2}
\alias{proto_frame_cor2}
\title{Tour proto for frames square correlation}
\usage{
proto_frame_cor2(
  text_size = 4,
  row_index = TRUE,
  xy_position = c(0.7, -0.1),
  ...
)
}
\arguments{
\item{text_size}{Size of the text. defaults to 4.}

\item{row_index}{A numeric or logical index of rows to subset to.
Defaults to NULL, all observations.}

\item{xy_position}{Vector of the x and y position, the fraction of the
range of the data in each direction. The projection data is contained in
(0, 1) in each direction. Defaults to c(.7, -.1), in the bottom right.}

\item{...}{Optionally, pass additional arguments to
\code{\link[stats:cor]{stats::cor}}, specifying the type of
within frame correlation.}
}
\description{
Adds text to the animation, the frame and its specified correlation.
}
\examples{
library(spinifex)
dat     <- scale_sd(penguins_na.rm[, 1:4])
clas    <- penguins_na.rm$species
gt_path <- save_history(dat, grand_tour(), max_bases = 5)

ggt <- ggtour(gt_path, dat, angle = .3) +
  proto_default(aes_args = list(color = clas, shape = clas)) +
  proto_frame_cor2(xy_position = c(.5, 1.1))
\dontrun{
animate_plotly(ggt)
}
}
\seealso{
\code{\link[stats:cor]{stats::cor}}
}
