% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/0_util.r
\name{array2df}
\alias{array2df}
\title{Turns a tour path array into a long data frame.}
\usage{
array2df(
  basis_array,
  data = NULL,
  basis_label = if (is.null(data) == FALSE) abbreviate(colnames(data), 3) else
    1:nrow(basis_array),
  data_label = if (is.null(data) == FALSE) abbreviate(colnames(data), 3) else
    paste0("v", 1:ncol(basis_array))
)
}
\arguments{
\item{basis_array}{A full (p, d, n_frames) interpolated basis array of a
tour, the output of \code{manual_tour} or \verb{save_history(*_tour())}.}

\item{data}{Optional, (n, p) dataset to project, consisting of numeric
variables.}

\item{basis_label}{Optional, labels for the reference frame, a character
vector of the number of variables.
Defaults to the 3 character abbreviation of the original variables names.}

\item{data_label}{Optional, labels for plotly tooltip and return object.
Defaults to the rownames of the data, if available, then the row number.}
}
\description{
Internal function, many end users will not need this. Takes the result of
\code{manual_tour()} or \code{tourr::save_history()}. Restructures the array of
interpolated bases into a long data frame for use in ggplots.
}
\examples{
## !!This function is not meant for external use!!
dat_std <- scale_sd(wine[, 2:6])
clas <- wine$Type
bas <- basis_pca(dat_std)
mv <- manip_var_of(bas)

## Radial tour array to long df, as used in play_manual_tour()
mt_array <- manual_tour(basis = bas, manip_var = mv)
ls_df_frames <- array2df(basis_array = mt_array, data = dat_std,
                         basis_label = paste0("MyLabs", 1:nrow(bas)))
str(ls_df_frames)

## tourr::save_history tour array to long df, as used in play_tour_path()
gt_array <- tourr::save_history(data = dat_std, max_bases = 10)
ls_df_frames2 <- array2df(basis_array = gt_array, data = dat_std)
str(ls_df_frames2)
}
