% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/util.r
\name{view_basis}
\alias{view_basis}
\title{Plot projection frame and return the axes table.}
\usage{
view_basis(basis, labels = paste0("V", 1:nrow(basis)), data = NULL,
  axes = "center")
}
\arguments{
\item{basis}{A (p, d) basis, XY linear combination of each dimension
(numeric variable).}

\item{labels}{Optional character vector of \code{p} length, add name to the axes
in the reference frame, typically the variable names.}

\item{data}{Optional (n, p) data, plots xy scatterplot on the frame}

\item{axes}{Position of the axes: "center", "bottomleft" or "off". Defaults
to "center".}
}
\value{
ggplot object of the basis.
}
\description{
Uses base graphics to plot the circle with axes representing
the projection frame. Returns the corresponding table.
}
\examples{
rb <- basis_random(4, 2)
view_basis(basis = rb)

flea_std <- tourr::rescale(tourr::flea[, 1:4])
view_basis(basis = rb, data = flea_std)
view_basis(basis = rb, data = flea_std, axes = "bottomleft")
}
