% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/spidR.R
\name{checknames}
\alias{checknames}
\title{Check taxa names in WSC.}
\usage{
checknames(tax, order = FALSE)
}
\arguments{
\item{tax}{A taxon name or vector with taxa names.}

\item{order}{Order taxa alphabetically or keep as in tax.}
}
\value{
If any mismatches, a matrix with taxa not found in WSC.
}
\description{
Check taxa names against the World Spider Catalogue.
}
\details{
This function will check if all species, genera and family names in tax are updated according to the World Spider Catalogue (2021). If not, it returns a matrix with valid synonym or possible misspellings using fuzzy matching (Levenshtein edit distance).
}
\examples{
\dontrun{
checknames(tax = c("Nemesis", "Nemesia brauni", "Iberesia machadoi", "Nemesia bacelari"))
}
}
\references{
World Spider Catalog (2021). World Spider Catalog. Version 22.0. Natural History Museum Bern, online at http://wsc.nmbe.ch. doi: 10.24436/2.
}
