% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/spftir.R
\name{spmbl}
\alias{spmbl}
\title{Linear Baseline Correction of a Mid-infrared Spectrum}
\usage{
spmbl(spectrum, lbl)
}
\arguments{
\item{spectrum}{matrix. The matrix of FTIR spectrum. The first row corresponds to wavenumber; the second row corresponds to absorbance.}

\item{lbl}{vector. Vector of zero points of absorbance (two or more points).}
}
\value{
A corrected spectrum matrix by means of a linear baseline. The first row corresponds to wavenumber; the second row corresponds to absorbance.
}
\description{
This function allows a linear correction of defects of the baseline of a mid-infrared spectrum.
}
\examples{
data(spData)
# Convert data frame to matrix
spectrum <- as.matrix(t(spData[, c("Wavenumber","A")]))
# Linear baseline correction
mbl <- spmbl(spectrum=spectrum, lbl=c(1800, 1540, 840))
}
\author{
Claudio Pozo Valenzuela [aut, cre] and Saddys Rodriguez-llamazares [aut]
}

