% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/spftir.R
\name{spder}
\alias{spder}
\title{N-derived of a Mid-infrared Spectra}
\usage{
spder(spectra, order = 2, p = 3, sw = 11)
}
\arguments{
\item{spectra}{matrix. The matrix of FTIR spectra. The first row corresponds to wavenumber; the remaining rows corresponds to absorbances.}

\item{order}{numeric. Order of derivative. Defaults to 2.}

\item{p}{numeric. Polynomial order (p>order). Defaults to 3.}

\item{sw}{numeric. Filter length (must be odd). Defaults to 11.}
}
\value{
A derivated spectra matrix. The first row corresponds to wavenumber; the second row corresponds to absorbance.
}
\description{
This function allows to determine the n-derivative of a mid-infrared spectra.
}
\examples{
data(spData)
# Convert data frame to matrix
spectra <- as.matrix(t(spData))
# Derivative spectra
der <- spder(spectra=spectra, order=2, p=3, sw= 11)
}
\author{
Claudio Pozo Valenzuela [aut, cre] and Saddys Rodriguez-llamazares [aut]
}

