% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/spftir.R
\name{spmws}
\alias{spmws}
\title{Moving-average Smoothing Filter of a Mid-infrared Spectrum}
\usage{
spmws(spectrum, N = 21)
}
\arguments{
\item{spectrum}{matrix. The matrix of FTIR spectrum. The first row corresponds to wavenumber; the second row corresponds to absorbances.}

\item{N}{numeric. Length of the smoothing window. Defaults to 21.}
}
\value{
A smoothed spectrum matrix by means of a Moving-average smoothing filter. The first row corresponds to wavenumber; the second row corresponds to absorbances.
}
\description{
This function allows applying a Moving-average smoothing filter to the mid-infrared spectrum (N spectra = 1).
}
\examples{
data(spData)
# Convert data frame to matrix
spectrum <- as.matrix(t(spData[, c("Wavenumber","A")]))
# Smoothed spectrum
mws <- spmws(spectrum = spectrum, N = 21)
}
\author{
Claudio Pozo Valenzuela [aut, cre] and Saddys Rodriguez-llamazares [aut]
}

