% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/class_0_generics-and-maybe-classes.R,
%   R/class_sp-network-multi.R
\name{pair_merge}
\alias{pair_merge}
\alias{pair_merge,sp_multi_network-method}
\title{Generic for merging information on origins and destination to node
pairs inside \link[=spflow_network_classes]{spflow network classes}}
\usage{
pair_merge(object, ...)

\S4method{pair_merge}{sp_multi_network}(object, network_pair_id, all_pairs = FALSE)
}
\arguments{
\item{object}{A \code{\link[=sp_multi_network-class]{sp_multi_network-class()}}}

\item{...}{Arguments to be passed to methods}

\item{network_pair_id}{A character indicating the id of a \code{\link[=sp_network_pair-class]{sp_network_pair-class()}}}

\item{all_pairs}{A logical, when set to \code{TRUE} the resulting data.frame contains all
possible pairs of origins and destination, even if the data in the
\code{\link[=sp_network_pair-class]{sp_network_pair-class()}} does not have them.}
}
\value{
A single data.frame, combining all available information on origins, destinations and OD pairs
}
\description{
For details on the methods see the documentation of the
corresponding classes.

The method merges all available information on origins and destinations to
the data.frame describing the pairs.
}
\examples{
# long form data for flows from Germany to Germany
pair_merge(multi_net_usa_ge,"ge_ge")

# long form data for flows from Germany to USA
pair_merge(multi_net_usa_ge,"ge_usa")
}
\seealso{
\code{\link[=sp_multi_network-class]{sp_multi_network-class()}}
}
