% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/summarize_spew.R
\name{summarize_syneco}
\alias{summarize_syneco}
\title{Summarize synthetic ecosystem for SPEW console output}
\usage{
summarize_syneco(syneco, vars_to_sum_h, vars_to_sum_p, vars_to_sum_env = NULL,
  samp_size = 10^4, marginals = NULL, top_region_id = "Ecosystem",
  has_marg = FALSE)
}
\arguments{
\item{syneco}{output from the 'spew' function}

\item{vars_to_sum_h}{character vector of variables from the household data frame output to summarize}

\item{vars_to_sum_p}{character vector of variables from the person data frame output to summarize}

\item{vars_to_sum_env}{character vector of variables from the person data frame which correspond to environment assignments.  Default is NULL.}

\item{samp_size}{number of agents to retain from each lower-level region, for plotting purposes only.  Default is 10^4.}

\item{marginals}{list containing all of the marginal totals.  See ?make_ipf_marg for more details.}

\item{top_region_id}{Name supplied of region.}

\item{has_marg}{Does the region of marginals to refer to?  Logical.  Default is FALSE.}
}
\value{
list with the household summary list, people summary list, header for households, and header for people, and a data frame of plotting coordinates by summary region
}
\description{
Summarize synthetic ecosystem for SPEW console output
}
