/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.gui.dock.support.menu;

import bibliothek.gui.dock.support.menu.MenuPieceListener;
import java.awt.Component;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import javax.swing.JMenu;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class MenuPiece {
    private MenuPiece parent;
    private List<MenuPieceListener> listeners = new ArrayList<MenuPieceListener>();
    private boolean bound = false;

    public void addListener(MenuPieceListener listener) {
        this.listeners.add(listener);
    }

    public void removeListener(MenuPieceListener listener) {
        this.listeners.remove(listener);
    }

    protected void fireInsert(int index, Component ... items) {
        for (MenuPieceListener listener : this.listeners.toArray(new MenuPieceListener[this.listeners.size()])) {
            listener.insert(this, index, items);
        }
    }

    protected void fireRemove(int index, int length) {
        for (MenuPieceListener listener : this.listeners.toArray(new MenuPieceListener[this.listeners.size()])) {
            listener.remove(this, index, length);
        }
    }

    public JMenu getMenu() {
        if (this.parent == null) {
            return null;
        }
        return this.parent.getMenu();
    }

    public MenuPiece getParent() {
        return this.parent;
    }

    public void setParent(MenuPiece parent) {
        this.parent = parent;
    }

    public void bind() {
        this.bound = true;
    }

    public void unbind() {
        this.bound = false;
    }

    public boolean isBound() {
        return this.bound;
    }

    public abstract int getItemCount();

    public abstract void fill(List<Component> var1);

    public Component[] items() {
        LinkedList<Component> items = new LinkedList<Component>();
        this.fill(items);
        return items.toArray(new Component[items.size()]);
    }
}

