/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.gui.dock.util.swing;

import bibliothek.gui.dock.util.font.FontModifier;
import java.awt.Font;
import java.awt.event.HierarchyEvent;
import java.awt.event.HierarchyListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.JComponent;

public class FontUpdater {
    private FontModifier modifier;
    private Font original;
    private boolean onFontUpdate = false;
    private JComponent component;

    public FontUpdater(JComponent component) {
        this.component = component;
        component.addPropertyChangeListener("font", new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent evt) {
                if (!FontUpdater.this.onFontUpdate) {
                    FontUpdater.this.original = (Font)evt.getNewValue();
                    FontUpdater.this.updateFont();
                }
            }
        });
        component.addHierarchyListener(new HierarchyListener(){

            public void hierarchyChanged(HierarchyEvent e) {
                FontUpdater.this.updateFont();
            }
        });
        this.original = component.getFont();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void enterUpdateUI() {
        try {
            this.onFontUpdate = false;
            this.component.setFont(this.original);
        }
        finally {
            this.onFontUpdate = false;
        }
    }

    public void leaveUpdateUI() {
        this.updateFont();
    }

    public void setFontModifier(FontModifier modifier) {
        if (this.modifier != modifier) {
            this.modifier = modifier;
            this.updateFont();
        }
    }

    public FontModifier getFontModifier() {
        return this.modifier;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateFont() {
        try {
            this.onFontUpdate = true;
            this.component.setFont(this.original);
            Font base = this.component.getFont();
            Font modified = base == null || this.modifier == null ? this.original : this.modifier.modify(base);
            this.component.setFont(modified);
        }
        finally {
            this.onFontUpdate = false;
        }
    }
}

