/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.gui.dock.control.relocator;

import bibliothek.gui.DockController;
import bibliothek.gui.DockStation;
import bibliothek.gui.Dockable;
import bibliothek.gui.dock.control.relocator.Merger;
import bibliothek.gui.dock.control.relocator.RelocateOperation;
import bibliothek.gui.dock.event.DockRelocatorListener;

public class MergeOperation
implements RelocateOperation {
    private DockController controller;
    private Merger merger;
    private DockStation station;

    public MergeOperation(DockController controller, Merger merger, DockStation station) {
        this.controller = controller;
        this.merger = merger;
        this.station = station;
    }

    public DockStation getStation() {
        return this.station;
    }

    public void execute(Dockable selection, DockRelocatorListener listener) {
        DockStation child = selection.asDockStation();
        Dockable[] children = new Dockable[child.getDockableCount()];
        for (int i = 0; i < children.length; ++i) {
            children[i] = child.getDockable(i);
            listener.drag(this.controller, children[i], child);
        }
        this.merger.merge(this.station, child);
        for (Dockable dockable : children) {
            listener.drop(this.controller, dockable, this.station);
        }
        DockStation parent = selection.getDockParent();
        if (parent != null && parent != this.station) {
            parent.drag(selection);
        }
    }
}

