/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.extension.gui.dock.theme.eclipse;

import bibliothek.gui.dock.control.focus.FocusAwareComponent;
import bibliothek.gui.dock.themes.basic.action.BasicButtonModel;
import bibliothek.gui.dock.themes.basic.action.BasicButtonModelAdapter;
import bibliothek.gui.dock.themes.basic.action.BasicResourceInitializer;
import bibliothek.gui.dock.themes.basic.action.BasicTrigger;
import bibliothek.gui.dock.util.AbstractPaintableComponent;
import bibliothek.gui.dock.util.BackgroundComponent;
import bibliothek.gui.dock.util.BackgroundPaint;
import bibliothek.util.Colors;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Graphics;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import javax.swing.Icon;
import javax.swing.JComponent;

public class RoundRectButton
extends JComponent
implements FocusAwareComponent {
    private BasicButtonModel model;
    private Runnable afterFocusRequest;

    public RoundRectButton(BasicTrigger trigger, BasicResourceInitializer initializer) {
        this.model = new BasicButtonModel(this, trigger, initializer, true);
        this.setOpaque(false);
        this.setFocusable(true);
        this.model.addListener(new BasicButtonModelAdapter(){

            public void mousePressed(BasicButtonModel model, boolean mousePressed) {
                if (!mousePressed) {
                    RoundRectButton.this.requestFocusInWindow();
                    RoundRectButton.this.invokeAfterFocusRequest();
                }
            }
        });
        this.addFocusListener(new FocusListener(){

            public void focusGained(FocusEvent e) {
                RoundRectButton.this.repaint();
            }

            public void focusLost(FocusEvent e) {
                RoundRectButton.this.repaint();
            }
        });
    }

    public void maybeRequestFocus() {
        this.afterFocusRequest = null;
        EventQueue.invokeLater(new Runnable(){

            public void run() {
                if (!RoundRectButton.this.model.isMousePressed()) {
                    RoundRectButton.this.requestFocusInWindow();
                    RoundRectButton.this.invokeAfterFocusRequest();
                }
            }
        });
    }

    public void invokeOnFocusRequest(Runnable run) {
        this.afterFocusRequest = run;
    }

    private void invokeAfterFocusRequest() {
        EventQueue.invokeLater(new Runnable(){

            public void run() {
                if (RoundRectButton.this.afterFocusRequest != null) {
                    RoundRectButton.this.afterFocusRequest.run();
                    RoundRectButton.this.afterFocusRequest = null;
                }
            }
        });
    }

    public BasicButtonModel getModel() {
        return this.model;
    }

    public Dimension getMinimumSize() {
        if (this.isMinimumSizeSet()) {
            return super.getMinimumSize();
        }
        return this.getPreferredSize();
    }

    public Dimension getPreferredSize() {
        if (this.isPreferredSizeSet()) {
            return super.getPreferredSize();
        }
        Dimension size = this.model.getMaxIconSize();
        size.width = Math.max(10, size.width + 4);
        size.height = Math.max(10, size.height + 4);
        return size;
    }

    protected void paintComponent(Graphics g) {
        BackgroundPaint paint = this.model.getBackground();
        BackgroundComponent component = this.model.getBackgroundComponent();
        if (paint == null) {
            this.doPaintBackground(g);
            this.doPaintForeground(g);
        } else {
            AbstractPaintableComponent paintable = new AbstractPaintableComponent(component, this, paint){

                protected void foreground(Graphics g) {
                    RoundRectButton.this.doPaintForeground(g);
                }

                protected void background(Graphics g) {
                    RoundRectButton.this.doPaintBackground(g);
                }

                protected void border(Graphics g) {
                }

                protected void children(Graphics g) {
                }

                protected void overlay(Graphics g) {
                }

                public boolean isSolid() {
                    return false;
                }

                public boolean isTransparent() {
                    return false;
                }
            };
            paintable.paint(g);
        }
    }

    private void doPaintBackground(Graphics g) {
        Color background = this.getBackground();
        Color border = null;
        if (this.model.isMousePressed()) {
            border = Colors.diffMirror(background, 0.3);
            background = Colors.undiffMirror(background, 0.6);
        } else if (this.model.isSelected() || this.model.isMouseInside()) {
            border = Colors.diffMirror(background, 0.3);
            background = Colors.undiffMirror(background, 0.3);
        }
        int w = this.getWidth() - 1;
        int h = this.getHeight() - 1;
        if (border != null) {
            g.setColor(background);
            g.fillRoundRect(0, 0, w, h, 4, 4);
            g.setColor(border);
            g.drawRoundRect(0, 0, w, h, 4, 4);
        }
    }

    private void doPaintForeground(Graphics g) {
        Color background = this.getBackground();
        if (this.model.isMousePressed()) {
            background = Colors.undiffMirror(background, 0.6);
        } else if (this.model.isSelected() || this.model.isMouseInside()) {
            background = Colors.undiffMirror(background, 0.3);
        }
        int w = this.getWidth() - 1;
        int h = this.getHeight() - 1;
        Icon icon = this.model.getPaintIcon();
        if (icon != null) {
            icon.paintIcon(this, g, (w + 1 - icon.getIconWidth()) / 2, (h + 1 - icon.getIconHeight()) / 2);
        }
        if (this.hasFocus() && this.isFocusable() && this.isEnabled()) {
            g.setColor(Colors.diffMirror(background, 0.4));
            g.drawLine(2, 3, 2, 4);
            g.drawLine(3, 2, 4, 2);
            g.drawLine(w - 2, 3, w - 2, 4);
            g.drawLine(w - 3, 2, w - 4, 2);
            g.drawLine(2, h - 3, 2, h - 4);
            g.drawLine(3, h - 2, 4, h - 2);
            g.drawLine(w - 2, h - 3, w - 2, h - 4);
            g.drawLine(w - 3, h - 2, w - 4, h - 2);
        }
    }
}

