/*
 * Decompiled with CFR 0.152.
 */
package org.odftoolkit.odfdom.doc;

import org.odftoolkit.odfdom.doc.OdfDocument;
import org.odftoolkit.odfdom.doc.office.OdfOfficeText;
import org.odftoolkit.odfdom.doc.text.OdfTextParagraph;
import org.w3c.dom.Node;

public class OdfTextDocument
extends OdfDocument {
    private static String EMPTY_TEXT_DOCUMENT_PATH = "/OdfTextDocument.odt";
    private static OdfDocument.Resource EMPTY_TEXT_DOCUMENT_RESOURCE = new OdfDocument.Resource(EMPTY_TEXT_DOCUMENT_PATH);

    public static OdfTextDocument newTextDocument() throws Exception {
        return (OdfTextDocument)OdfDocument.loadTemplate(EMPTY_TEXT_DOCUMENT_RESOURCE);
    }

    public static OdfTextDocument newTextTemplateDocument() throws Exception {
        OdfTextDocument doc = (OdfTextDocument)OdfDocument.loadTemplate(EMPTY_TEXT_DOCUMENT_RESOURCE);
        doc.changeMode(OdfMediaType.TEXT_TEMPLATE);
        return doc;
    }

    public static OdfTextDocument newTextMasterDocument() throws Exception {
        OdfTextDocument doc = (OdfTextDocument)OdfDocument.loadTemplate(EMPTY_TEXT_DOCUMENT_RESOURCE);
        doc.changeMode(OdfMediaType.TEXT_MASTER);
        return doc;
    }

    public static OdfTextDocument newTextWebDocument() throws Exception {
        OdfTextDocument doc = (OdfTextDocument)OdfDocument.loadTemplate(EMPTY_TEXT_DOCUMENT_RESOURCE);
        doc.changeMode(OdfMediaType.TEXT_WEB);
        return doc;
    }

    protected OdfTextDocument() {
    }

    public OdfOfficeText getContentRoot() throws Exception {
        return super.getContentRoot(OdfOfficeText.class);
    }

    public OdfTextParagraph newParagraph(String text) throws Exception {
        OdfTextParagraph para = this.newParagraph();
        para.addContent(text);
        return para;
    }

    public OdfTextParagraph newParagraph() throws Exception {
        OdfOfficeText odfText = this.getContentRoot();
        return (OdfTextParagraph)odfText.newTextPElement();
    }

    public OdfTextParagraph addText(String text) throws Exception {
        OdfOfficeText odfText = this.getContentRoot();
        Node n = odfText.getLastChild();
        OdfTextParagraph para = OdfTextParagraph.class.isInstance(n) ? (OdfTextParagraph)((Object)n) : this.newParagraph();
        para.addContent(text);
        return para;
    }

    public void changeMode(OdfMediaType type) {
        this.setMediaType(type.getOdfMediaType());
        this.getPackage().setMediaType(type.toString());
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum OdfMediaType {
        TEXT(OdfDocument.OdfMediaType.TEXT),
        TEXT_TEMPLATE(OdfDocument.OdfMediaType.TEXT_TEMPLATE),
        TEXT_MASTER(OdfDocument.OdfMediaType.TEXT_MASTER),
        TEXT_WEB(OdfDocument.OdfMediaType.TEXT_WEB);

        private final OdfDocument.OdfMediaType mMediaType;

        private OdfMediaType(OdfDocument.OdfMediaType mediaType) {
            this.mMediaType = mediaType;
        }

        public String toString() {
            return this.mMediaType.toString();
        }

        public OdfDocument.OdfMediaType getOdfMediaType() {
            return this.mMediaType;
        }

        public String getName() {
            return this.mMediaType.getName();
        }

        public String getSuffix() {
            return this.mMediaType.getSuffix();
        }

        public static OdfDocument.OdfMediaType getOdfMediaType(String mediaType) {
            return OdfDocument.OdfMediaType.getOdfMediaType(mediaType);
        }
    }
}

