/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.util.xml;

import bibliothek.util.xml.XException;

public class XContainer {
    private String value = "";

    public XContainer copy() {
        XContainer xContainer = new XContainer();
        xContainer.copy(this);
        return xContainer;
    }

    protected void copy(XContainer xContainer) {
        this.value = xContainer.value;
    }

    public void setValue(String string) {
        this.value = string;
    }

    public String getValue() {
        return this.value;
    }

    public void setByte(byte by) {
        this.value = String.valueOf(by);
    }

    public void setShort(short s) {
        this.value = String.valueOf(s);
    }

    public void setInt(int n) {
        this.value = String.valueOf(n);
    }

    public void setLong(long l) {
        this.value = String.valueOf(l);
    }

    public void setBoolean(boolean bl) {
        this.value = String.valueOf(bl);
    }

    public void setChar(char c) {
        this.value = String.valueOf(c);
    }

    public void setString(String string) {
        if (string == null) {
            throw new IllegalArgumentException("value must not be null");
        }
        this.value = string;
    }

    public void setFloat(float f) {
        this.value = String.valueOf(f);
    }

    public void setDouble(double d) {
        this.value = String.valueOf(d);
    }

    public void setByteArray(byte[] byArray) {
        StringBuilder stringBuilder = new StringBuilder(byArray.length * 2);
        for (byte by : byArray) {
            stringBuilder.append(Integer.toHexString(by >> 4 & 0xF));
            stringBuilder.append(Integer.toHexString(by & 0xF));
        }
        this.value = stringBuilder.toString();
    }

    public byte getByte() {
        try {
            return Byte.parseByte(this.value);
        }
        catch (NumberFormatException numberFormatException) {
            throw new XException(numberFormatException);
        }
    }

    public short getShort() {
        try {
            return Short.parseShort(this.value);
        }
        catch (NumberFormatException numberFormatException) {
            throw new XException(numberFormatException);
        }
    }

    public int getInt() {
        try {
            return Integer.parseInt(this.value);
        }
        catch (NumberFormatException numberFormatException) {
            throw new XException(numberFormatException);
        }
    }

    public long getLong() {
        try {
            return Long.parseLong(this.value);
        }
        catch (NumberFormatException numberFormatException) {
            throw new XException(numberFormatException);
        }
    }

    public float getFloat() {
        try {
            return Float.parseFloat(this.value);
        }
        catch (NumberFormatException numberFormatException) {
            throw new XException(numberFormatException);
        }
    }

    public double getDouble() {
        try {
            return Double.parseDouble(this.value);
        }
        catch (NumberFormatException numberFormatException) {
            throw new XException(numberFormatException);
        }
    }

    public char getChar() {
        if (this.value.length() != 1) {
            throw new XException("not a character: " + this.value);
        }
        return this.value.charAt(0);
    }

    public String getString() {
        return this.value;
    }

    public boolean getBoolean() {
        String string = this.value.trim().toLowerCase();
        if ("true".equals(string)) {
            return true;
        }
        if ("on".equals(string)) {
            return true;
        }
        if ("1".equals(string)) {
            return true;
        }
        if ("yes".equals(string)) {
            return true;
        }
        if ("false".equals(string)) {
            return false;
        }
        if ("off".equals(string)) {
            return false;
        }
        if ("0".equals(string)) {
            return false;
        }
        if ("no".equals(string)) {
            return false;
        }
        throw new XException("not a boolean: " + string);
    }

    public byte[] getByteArray() {
        if (this.value.length() % 2 != 0) {
            throw new XException("value is not a byte-array: " + this.value);
        }
        byte[] byArray = new byte[this.value.length() / 2];
        int n = this.value.length();
        for (int i = 0; i < n; ++i) {
            char c = this.value.charAt(i);
            int n2 = 0;
            switch (c) {
                case '0': {
                    n2 = 0;
                    break;
                }
                case '1': {
                    n2 = 1;
                    break;
                }
                case '2': {
                    n2 = 2;
                    break;
                }
                case '3': {
                    n2 = 3;
                    break;
                }
                case '4': {
                    n2 = 4;
                    break;
                }
                case '5': {
                    n2 = 5;
                    break;
                }
                case '6': {
                    n2 = 6;
                    break;
                }
                case '7': {
                    n2 = 7;
                    break;
                }
                case '8': {
                    n2 = 8;
                    break;
                }
                case '9': {
                    n2 = 9;
                    break;
                }
                case 'a': {
                    n2 = 10;
                    break;
                }
                case 'b': {
                    n2 = 11;
                    break;
                }
                case 'c': {
                    n2 = 12;
                    break;
                }
                case 'd': {
                    n2 = 13;
                    break;
                }
                case 'e': {
                    n2 = 14;
                    break;
                }
                case 'f': {
                    n2 = 15;
                    break;
                }
                default: {
                    throw new XException("value is not a byte-array: " + n2);
                }
            }
            if (i % 2 == 0) {
                byArray[i / 2] = (byte)(n2 << 4);
                continue;
            }
            int n3 = i / 2;
            byArray[n3] = (byte)(byArray[n3] | n2);
        }
        return byArray;
    }
}

